/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.lai2010;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.Package;
import tech.nmfin.portfoliooptimization.lai2010.ceta.Ceta;
import tech.nmfin.portfoliooptimization.lai2010.ceta.maximizer.CetaMaximizer;
import tech.nmfin.portfoliooptimization.lai2010.ceta.maximizer.GridSearchCetaMaximizer;
import tech.nmfin.portfoliooptimization.lai2010.ceta.npeb.NPEBPortfolioMomentsEstimator;
import tech.nmfin.portfoliooptimization.lai2010.ceta.npeb.resampler.GroupResamplerFactory;
import tech.nmfin.portfoliooptimization.lai2010.ceta.npeb.resampler.ReturnsResamplerFactory;
import tech.nmfin.portfoliooptimization.lai2010.optimizer.MVOptimizer;
import tech.nmfin.returns.moments.MomentsEstimatorLedoitWolf;
import tech.nmfin.returns.moments.ReturnsMoments;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Lai2010NPEBModel {
    private final int const;
    private final CetaMaximizer void;
    private final ReturnsResamplerFactory class;
    private final ReturnsMoments.Estimator goto;
    private final MVOptimizer enum;

    public Lai2010NPEBModel(MVOptimizer mvOptimizer, int nBootstraps, ReturnsMoments.Estimator returnsMomentsEstimator, ReturnsResamplerFactory resamplerFactory, CetaMaximizer cetaMaximizer) {
        this.enum = mvOptimizer;
        this.const = nBootstraps;
        this.goto = returnsMomentsEstimator;
        this.class = resamplerFactory;
        this.void = cetaMaximizer;
    }

    public Lai2010NPEBModel(MVOptimizer optimizer, int nBootstraps) {
        this(optimizer, nBootstraps, new MomentsEstimatorLedoitWolf(), new GroupResamplerFactory(), new GridSearchCetaMaximizer());
    }

    static {
        Package.validate("ALGOQUANT_LAI2010");
    }

    public OptimalWeights optimalWeights(Matrix returns, double lambda) {
        NPEBPortfolioMomentsEstimator a2 = new NPEBPortfolioMomentsEstimator(returns, this.goto, this.enum, this.class, this.const);
        Ceta a3 = new Ceta(a2, lambda);
        CetaMaximizer.Solution a4 = this.void.search(a3, 1.0, 10.0);
        double a5 = a4.eta();
        System.out.printf("optimal eta = %f%n", a5);
        ReturnsMoments a6 = this.goto.estimate(returns);
        Vector a7 = this.enum.optimalWeights(a6.mu(), a6.V(), lambda, a5);
        Ceta.PortfolioMoments a8 = a2.evaluate(lambda, a5);
        return new OptimalWeights(a7, a8);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class OptimalWeights {
        private final Ceta.PortfolioMoments goto;
        private final Vector enum;

        public Vector weights() {
            return this.enum;
        }

        public Ceta.PortfolioMoments moments() {
            return this.goto;
        }

        public double ir() {
            double a2 = this.goto.moment1();
            double a3 = Math.sqrt(this.goto.moment2());
            double a4 = a2 / a3;
            return a4;
        }

        public OptimalWeights(Vector weights, Ceta.PortfolioMoments moments) {
            this.enum = weights;
            this.goto = moments;
        }
    }
}

