/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.meanreversion.cointegration;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.license.InvalidLicense;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.stat.factor.implicitmodelpca.ImplicitModelPCA;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tech.nmfin.meanreversion.cointegration.PairingModel;
import tech.nmfin.meanreversion.cointegration.PairingModelUtils;
import tech.nmfin.meanreversion.cointegration.RobustCointegration;
import tech.nmfin.meanreversion.cointegration.TradingPair;
import tech.nmfin.meanreversion.cointegration.check.CorrelationCheck;
import tech.nmfin.returns.ReturnsCalculators;
import tech.nmfin.returns.ReturnsMatrix;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PairingModel2
implements PairingModel {
    private final double class;
    private final double goto;
    private final double enum;

    public PairingModel2(double lowerCorrelationBound, double upperCorrelationBound, double tail) {
        this.goto = lowerCorrelationBound;
        this.class = upperCorrelationBound;
        this.enum = tail;
    }

    @Override
    public List<TradingPair> getTradingPairs(final List<String> allSymbols, List<String> tradableSymbols, final Matrix prices) {
        int a2 = allSymbols.size();
        final List<Integer[]> a3 = allSymbols.size() == tradableSymbols.size() ? PairingModelUtils.getPossiblePairs(a2) : PairingModelUtils.getPossiblePairs(allSymbols, tradableSymbols);
        ReturnsMatrix a4 = new ReturnsMatrix(prices, ReturnsCalculators.LOG);
        int a5 = a4.nRows();
        ImplicitModelPCA a6 = new ImplicitModelPCA((Matrix)a4, 1);
        ImplicitModelPCA.Result a7 = a6.run();
        Vector[] a8 = new Vector[a5];
        for (int a9 = 0; a9 < a5; ++a9) {
            a8[a9] = a7.e_t(a9 + 1);
        }
        final Matrix a10 = MatrixFactory.rbind(a8);
        final List<TradingPair> a11 = Collections.synchronizedList(new ArrayList());
        ParallelExecutor a12 = new ParallelExecutor(PairingModel2.class.getSimpleName());
        try {
            a12.forLoop(0, a3.size(), new LoopBody(){

                @Override
                public void run(int i2) {
                    Integer[] a2 = (Integer[])a3.get(i2);
                    TradingPair a32 = PairingModel2.this.do(a2, allSymbols, prices, a10);
                    if (a32 != null) {
                        a11.add(a32);
                    }
                }
                {
                    1 a32;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return a11;
    }

    private TradingPair do(Integer[] a2, List<String> a3, Matrix a4, Matrix a5) {
        int a6 = a2[0];
        int a7 = a2[1];
        String a8 = a3.get(a6);
        String a9 = a3.get(a7);
        Vector a10 = a4.getColumn(a6 + 1);
        Vector a11 = a4.getColumn(a7 + 1);
        final Vector a12 = a5.getColumn(a6 + 1);
        final Vector a13 = a5.getColumn(a7 + 1);
        try {
            PairingModel2 a14;
            RobustCointegration a15 = new RobustCointegration();
            Matrix a16 = PairingModelUtils.getPriceMatrix(a12, a13);
            CorrelationCheck a17 = new CorrelationCheck(a16, a14.goto, a14.class);
            a15.addCheck(a17);
            CorrelationCheck a18 = new CorrelationCheck(a16, a14.enum, a14.goto, a14.class);
            a15.addCheck(a18);
            TradingPair a19 = a15.computeRobustPair(a8, a9, a10, a11);
            TradingPair a20 = new TradingPair(a8, a9, a10, a11, a19.beta()){
                {
                    2 a8;
                    super(a3, a4, a5, a6, a7);
                }

                @Override
                public double cor(double tailed) {
                    Matrix a2 = MatrixFactory.cbind(a12, a13);
                    double a3 = CorrelationCheck.cor(a2, tailed);
                    return a3;
                }
            };
            return a20;
        }
        catch (InvalidLicense a21) {
            System.out.println(a21.toString());
            return null;
        }
        catch (Exception a22) {
            return null;
        }
    }
}

