/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.factor.pca;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Eigen;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseVector;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.stat.descriptive.correlation.CorrelationMatrix;
import dev.nm.stat.descriptive.covariance.SampleCovariance;
import dev.nm.stat.factor.pca.PCAImpl;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PCAbyEigen
extends PCAImpl {
    private Eigen void = null;
    private final ImmutableMatrix class;
    private final boolean goto;
    private Matrix enum = null;

    public PCAbyEigen(Matrix data, boolean correlation, Matrix V) {
        super(data);
        if (V != null) {
            ArgumentAssertion.assertTrue(V.nCols() == this.nFactors() && V.nRows() == this.nFactors(), "V is a p*p square matrix, where p is the number of columns of data", new Object[0]);
        }
        this.goto = correlation;
        this.class = V != null ? new ImmutableMatrix(V) : null;
    }

    public Eigen eigen() {
        if (this.void == null) {
            this.void = new Eigen(this.V(), Eigen.Method.SYMMETRY);
        }
        return this.void;
    }

    @Override
    public Vector sdPrincipalComponents() {
        double[] a2 = this.eigen().getRealEigenvalues();
        double[] a3 = DoubleArrayMath.sqrt(a2);
        return new DenseVector(a3);
    }

    @Override
    public Vector loading(int i2) {
        double[] a2 = this.eigen().getRealEigenvalues();
        int a3 = a2.length;
        ArgumentAssertion.assertTrue(i2 >= 1 && i2 <= a3, "out-of-range [1, %d] loading index %d", a3, i2);
        int a4 = this.nFactors();
        if (i2 <= a4) {
            return this.eigen().getProperty(i2 - 1).eigenVector();
        }
        return new SparseVector(a4);
    }

    public PCAbyEigen(Matrix data) {
        this(data, true);
    }

    @Override
    public Vector scale() {
        if (this.goto) {
            return super.scale();
        }
        return new DenseVector(DoubleUtils.rep(1.0, this.nFactors()));
    }

    public PCAbyEigen(Matrix data, boolean correlation) {
        this(data, correlation, null);
    }

    @Override
    public Matrix loadings() {
        double[] a2 = this.eigen().getRealEigenvalues();
        int a3 = a2.length;
        ArrayList<Vector> a4 = new ArrayList<Vector>(a3);
        for (int a5 = 1; a5 <= a3; ++a5) {
            a4.add(this.loading(a5));
        }
        return MatrixFactory.cbind(a4);
    }

    @Override
    public Vector proportionVar() {
        Vector a2 = this.sdPrincipalComponents();
        double a3 = MatrixMeasure.tr(this.V());
        int a4 = a2.size();
        double[] a5 = new double[a4];
        for (int a6 = 0; a6 < a4; ++a6) {
            a5[a6] = a2.get(a6 + 1) * a2.get(a6 + 1);
        }
        return new DenseVector(a5).scaled(1.0 / a3);
    }

    public Matrix V() {
        if (this.class != null) {
            return this.class;
        }
        if (this.enum != null) {
            return this.enum;
        }
        this.enum = this.goto ? new CorrelationMatrix((Matrix)new SampleCovariance(this.X())) : new SampleCovariance(this.X());
        return this.enum;
    }
}

