/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralizedParetoDistribution
implements UnivariateEVD {
    private final double class;
    private final double goto;
    private final double enum;

    @Override
    public double kurtosis() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public GeneralizedParetoDistribution(double scale, double shape) {
        this(0.0, scale, shape);
    }

    @Override
    public double quantile(double p) {
        ArgumentAssertion.assertRangeOpen(p, 0.0, 1.0, "probability p");
        if (this.enum == 0.0) {
            return this.class - this.goto * Math.log(1.0 - p);
        }
        return this.class + this.goto * (Math.pow(1.0 - p, -this.enum) - 1.0) / this.enum;
    }

    public GeneralizedParetoDistribution(double location, double scale, double shape) {
        ArgumentAssertion.assertPositive(scale, "scale");
        this.class = location;
        this.goto = scale;
        this.enum = shape;
    }

    @Override
    public double skew() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double variance() {
        if (this.enum < 0.5) {
            double a2 = 1.0 - this.enum;
            double a3 = a2 - this.enum;
            return this.goto * this.goto / (a2 * a2 * a3);
        }
        throw new RuntimeException("variance only exists if shape < 0.5");
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double logDensity(double x) {
        boolean a2;
        double a3 = (x - this.class) / this.goto;
        boolean bl = a2 = a3 > 0.0 && 1.0 + this.enum * a3 > 0.0 || a3 == Double.NaN;
        if (!a2) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.enum == 0.0) {
            return Math.log(1.0 / this.goto) - a3;
        }
        return Math.log(1.0 / this.goto) - (1.0 + 1.0 / this.enum) * Math.log(1.0 + this.enum * a3);
    }

    @Override
    public double cdf(double x) {
        if (x < this.class) {
            return 0.0;
        }
        double a2 = (x - this.class) / this.goto;
        if (this.enum == 0.0) {
            return 1.0 - Math.exp(-a2);
        }
        double a3 = 1.0 + this.enum * a2;
        if (this.enum < 0.0 && a3 < 0.0) {
            return 1.0;
        }
        return 1.0 - Math.pow(a3, -1.0 / this.enum);
    }

    @Override
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double mean() {
        if (this.enum < 1.0) {
            return this.class + this.goto / (1.0 - this.enum);
        }
        throw new RuntimeException("mean only exists if shape < 1");
    }

    @Override
    public double median() {
        return this.class + this.goto * (Math.pow(2.0, this.enum) - 1.0) / this.enum;
    }

    static {
        Package.validate("NMDEV_EVT");
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    public GeneralizedParetoDistribution() {
        this(0.0, 1.0, 0.0);
    }
}

