/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.univariate;

import dev.nm.analysis.function.special.gamma.Gamma;
import dev.nm.analysis.function.special.gamma.GammaLanczosQuick;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.evt.evd.univariate.UnivariateEVD;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralizedEVD
implements UnivariateEVD {
    private static final Gamma void;
    private final double class;
    private final double goto;
    private final double enum;

    public GeneralizedEVD() {
        this(0.0, 1.0, 0.0);
    }

    @Override
    public double quantile(double p) {
        ArgumentAssertion.assertRangeOpen(p, 0.0, 1.0, "probability p");
        return this.marginalInverseTransform(-Math.log(p));
    }

    @Override
    public double variance() {
        if (this.enum == 0.0) {
            return this.class * this.class * (Math.PI * Math.PI) / 6.0;
        }
        if (this.enum < 0.5) {
            double a2 = this.class / this.enum;
            double a3 = this.do(1);
            double a4 = this.do(2);
            return a2 * a2 * (a4 - a3 * a3);
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    public double getLocation() {
        return this.goto;
    }

    public double getShape() {
        return this.enum;
    }

    static {
        Package.validate("NMDEV_EVT");
        void = new GammaLanczosQuick();
    }

    public double getScale() {
        return this.class;
    }

    private boolean do(double a2) {
        GeneralizedEVD a3;
        return 1.0 + a3.enum * (a2 - a3.goto) / a3.class > 0.0;
    }

    public GeneralizedEVD(double location, double scale, double shape) {
        ArgumentAssertion.assertPositive(scale, "scale");
        this.goto = location;
        this.class = scale;
        this.enum = shape;
    }

    @Override
    public double cdf(double x) {
        if (!this.do(x)) {
            return 0.0;
        }
        return Math.exp(-this.marginalTransform(x));
    }

    @Override
    public double entropy() {
        double a2 = 0.5772156649015329;
        return Math.log(this.class) + a2 * this.enum + (a2 + 1.0);
    }

    public double marginalInverseTransform(double x) {
        if (this.enum != 0.0) {
            return (Math.pow(x, -this.enum) - 1.0) / this.enum * this.class + this.goto;
        }
        return this.goto - this.class * Math.log(x);
    }

    @Override
    public double mean() {
        if (this.enum == 0.0) {
            return this.goto + this.class * 0.5772156649015329;
        }
        if (this.enum < 1.0) {
            return this.goto + this.class * (this.do(1) - 1.0) / this.enum;
        }
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double kurtosis() {
        if (this.enum == 0.0) {
            return 2.4;
        }
        double a2 = this.do(1);
        double a3 = this.do(2);
        double a4 = this.do(3);
        double a5 = this.do(4);
        double a6 = a2 * a2;
        double a7 = a6 * a6;
        return (a5 - 4.0 * a2 * a4 + 6.0 * a3 * a6 - 3.0 * a7) / (a3 - a6) / (a3 - a6) - 3.0;
    }

    private double do(int a2) {
        GeneralizedEVD a3;
        return void.evaluate(1.0 - (double)a2 * a3.enum);
    }

    @Override
    public double moment(double x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double logDensity(double x) {
        double a2 = (x - this.goto) / this.class;
        if (this.enum == 0.0) {
            return Math.log(1.0 / this.class) - a2 - Math.exp(-a2);
        }
        double a3 = a2 * this.enum + 1.0;
        if (a3 > 0.0 || a3 == Double.NaN) {
            return Math.log(1.0 / this.class) - Math.pow(a3, -1.0 / this.enum) - (1.0 / this.enum + 1.0) * Math.log(a3);
        }
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double median() {
        if (this.enum == 0.0) {
            return this.goto - this.class * Math.log(Math.log(2.0));
        }
        return this.goto + this.class * (Math.pow(Math.log(2.0), -this.enum) - 1.0) / this.enum;
    }

    public double marginalTransform(double x) {
        if (this.enum != 0.0) {
            return Math.pow(Math.max(1.0 + this.enum * (x - this.goto) / this.class, 0.0), -1.0 / this.enum);
        }
        return Math.exp(-(x - this.goto) / this.class);
    }

    @Override
    public double skew() {
        if (this.enum == 0.0) {
            return 12.0 * Math.sqrt(6.0) * 1.2020569031595942 / Math.pow(Math.PI, 3.0);
        }
        double a2 = this.do(1);
        double a3 = this.do(2);
        double a4 = this.do(3);
        return (a4 - 3.0 * a2 * a3 + 2.0 * a2 * a2 * a2) / Math.pow(a3 - a2 * a2, 1.5);
    }
}

