/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.bivariate;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.ExponentialDistribution;
import dev.nm.stat.evt.evd.bivariate.AbstractBivariateEVD;
import dev.nm.stat.evt.evd.univariate.GeneralizedEVD;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDLogistic
extends AbstractBivariateEVD {
    private final double const;
    private final UniformRNG void = new UniformRNG();
    private static final ExponentialDistribution class;
    private final GeneralizedEVD goto;
    private final GeneralizedEVD enum;

    static {
        Package.validate("NMDEV_EVT");
        BivariateEVDLogistic.class = new ExponentialDistribution();
    }

    public BivariateEVDLogistic(double dependence, GeneralizedEVD marginal) {
        this(dependence, marginal, marginal);
    }

    public GeneralizedEVD getMarginal1() {
        return this.enum;
    }

    public BivariateEVDLogistic(double dependence, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertRangeLeftOpen(dependence, 0.0, 1.0, "dependence");
        this.const = dependence;
        this.enum = marginal1;
        this.goto = marginal2;
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = 1.0 / this.const;
        return (a2 - 1.0) * Math.pow(x * (1.0 - x), -1.0 - a2) * Math.pow(Math.pow(x, -a2) + Math.pow(1.0 - x, -a2), this.const - 2.0);
    }

    @Override
    public void seed(long ... seeds) {
        this.void.seed(seeds);
    }

    public BivariateEVDLogistic(double dependence) {
        this(dependence, new GeneralizedEVD());
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        double a2 = -Math.log(x1);
        double a3 = -Math.log(x2);
        double a4 = 1.0 / this.const;
        double a5 = Math.pow(a2, a4) + Math.pow(a3, a4);
        double a6 = Math.pow(a5, this.const);
        double a7 = Math.exp(-a6) * (1.0 / x2) * Math.pow(a3, a4 - 1.0) * Math.pow(a5, this.const - 1.0);
        return a7;
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.enum.marginalTransform(x1);
        double a3 = this.goto.marginalTransform(x2);
        double a4 = Math.pow(Math.pow(a2, 1.0 / this.const) + Math.pow(a3, 1.0 / this.const), this.const);
        return Math.exp(-a4);
    }

    private double do() {
        BivariateEVDLogistic a2;
        double a3 = a2.void.nextDouble();
        return BivariateEVDLogistic.class.quantile(a3);
    }

    @Override
    public double[] nextVector() {
        double[] a2 = new double[2];
        double a3 = this.void.nextDouble() < this.const ? this.do() + this.do() : this.do();
        double a4 = this.void.nextDouble();
        a2[0] = 1.0 / (a3 * Math.pow(a4, this.const));
        a2[1] = 1.0 / (a3 * Math.pow(1.0 - a4, this.const));
        double a5 = this.enum.marginalInverseTransform(1.0 / a2[0]);
        double a6 = this.goto.marginalInverseTransform(1.0 / a2[1]);
        return new double[]{a5, a6};
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.enum.marginalTransform(x1);
        double a4 = this.goto.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            double a5 = 1.0 / this.const;
            double a6 = Math.pow(Math.pow(a3, a5) + Math.pow(a4, a5), this.const);
            double a7 = Math.log(a3);
            double a8 = Math.log(a4);
            a2 = (a5 + this.enum.getShape()) * a7 + (a5 + this.goto.getShape()) * a8 - Math.log(this.enum.getScale() * this.goto.getScale()) + (1.0 - 2.0 * a5) * Math.log(a6) + Math.log(a5 - 1.0 + a6) - a6;
        }
        return Math.exp(a2);
    }

    public GeneralizedEVD getMarginal2() {
        return this.goto;
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = 1.0 / this.const;
        return Math.pow(Math.pow(x, a2) + Math.pow(1.0 - x, a2), this.const);
    }
}

