/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.bivariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.root.univariate.BrentRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.analysis.root.univariate.Uniroot;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.misc.license.Package;
import dev.nm.stat.evt.evd.bivariate.AbstractBivariateEVD;
import dev.nm.stat.evt.evd.univariate.GeneralizedEVD;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDBilogistic
extends AbstractBivariateEVD {
    private final UniformRNG catch = new UniformRNG();
    private static final Uniroot const;
    private final GeneralizedEVD void;
    private final double class;
    private final double goto;
    private final GeneralizedEVD enum;

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = this.short(x);
        double a3 = x * Math.pow(a2, 1.0 - this.class) + (1.0 - x) * Math.pow(1.0 - a2, 1.0 - this.goto);
        double a4 = Math.exp(Math.log(1.0 - this.class) + Math.log(this.goto) + (this.goto - 1.0) * Math.log(1.0 - a2) + Math.log(1.0 - x)) + Math.exp(Math.log(1.0 - this.goto) + Math.log(this.class) + (this.class - 1.0) * Math.log(a2) + Math.log(x));
        a4 = Math.exp(Math.log(1.0 - this.class) + Math.log(1.0 - this.goto) - Math.log(x * (1.0 - x)) - Math.log(a4));
        return a4;
    }

    public BivariateEVDBilogistic(double alpha, double beta, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertRange(alpha, 0.0, 1.0, "alpha");
        ArgumentAssertion.assertRange(beta, 0.0, 1.0, "beta");
        this.class = alpha;
        this.goto = beta;
        this.void = marginal1;
        this.enum = marginal2;
    }

    private double break(double a2, double a3) {
        BivariateEVDBilogistic a4;
        return (1.0 - a4.class) * (1.0 - a2) * Math.pow(1.0 - a3, a4.goto) - (1.0 - a4.goto) * a2 * Math.pow(a3, a4.class);
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.void.marginalTransform(x1);
        double a3 = this.enum.marginalTransform(x2);
        double a4 = this.do(a2, a3);
        return Math.exp(-(a2 * Math.pow(a4, 1.0 - this.class) + a3 * Math.pow(1.0 - a4, 1.0 - this.goto)));
    }

    private double short(final double a2) {
        double a3;
        BivariateEVDBilogistic a4;
        if (a2 == 0.0) {
            return 0.0;
        }
        if (a2 == 1.0) {
            return 1.0;
        }
        AbstractUnivariateRealFunction a5 = new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double z) {
                return BivariateEVDBilogistic.this.break(a2, z);
            }
            {
                3 a3;
            }
        };
        try {
            a3 = const.solve(a5, 0.0, 1.0, new double[0]);
        }
        catch (NoRootFoundException a6) {
            a3 = a6.x();
        }
        return a3;
    }

    public BivariateEVDBilogistic(double alpha, double beta) {
        this(alpha, beta, new GeneralizedEVD());
    }

    private double short(double a2, double a3, double a4) {
        BivariateEVDBilogistic a5;
        return (1.0 - a5.class) * a2 * Math.pow(1.0 - a4, a5.goto) - (1.0 - a5.goto) * a3 * Math.pow(a4, a5.class);
    }

    private double do(double a2, double a3, double a4) {
        BivariateEVDBilogistic a5;
        return (1.0 - a5.class) * a2 * Math.pow(1.0 - a4, a5.goto) - (1.0 - a5.goto) * a3 * Math.pow(a4, a5.class);
    }

    @Override
    public void seed(long ... seeds) {
        this.catch.seed(seeds);
    }

    private double do(final double a2) {
        double a3;
        BivariateEVDBilogistic a4;
        if (a2 == 0.0) {
            return 0.0;
        }
        if (a2 == 1.0) {
            return 1.0;
        }
        AbstractUnivariateRealFunction a5 = new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double z) {
                return BivariateEVDBilogistic.this.short(a2, z);
            }
            {
                4 a3;
            }
        };
        try {
            a3 = const.solve(a5, 0.0, 1.0, new double[0]);
        }
        catch (NoRootFoundException a6) {
            a3 = a6.x();
        }
        return a3;
    }

    static {
        Package.validate("NMDEV_EVT");
        const = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    @Override
    public double density(double x1, double x2) {
        double a2 = this.void.marginalTransform(x1);
        double a3 = this.enum.marginalTransform(x2);
        double a4 = this.goto(a2, a3);
        if (a2 == 0.0 || a3 == 0.0 || Double.isInfinite(a2) || Double.isInfinite(a3)) {
            double d2 = Double.NEGATIVE_INFINITY;
        }
        double a5 = a2 * Math.pow(a4, 1.0 - this.class) + a3 * Math.pow(1.0 - a4, 1.0 - this.goto);
        double a6 = Math.log(a2);
        double a7 = Math.log(a3);
        double a8 = (1.0 + this.void.getShape()) * a6 + (1.0 + this.enum.getShape()) * a7 - Math.log(this.void.getScale() * this.enum.getScale());
        double a9 = Math.exp((1.0 - this.class) * Math.log(a4) + (1.0 - this.goto) * Math.log(1.0 - a4));
        double a10 = Math.exp(Math.log(1.0 - this.class) + Math.log(this.goto) + (this.goto - 1.0) * Math.log(1.0 - a4) + a6) + Math.exp(Math.log(1.0 - this.goto) + Math.log(this.class) + (this.class - 1.0) * Math.log(a4) + a7);
        double a11 = Math.log(a9 + (1.0 - this.class) * (1.0 - this.goto) / a10) - a5 + a8;
        return Math.exp(a11);
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.case(x1, x2);
    }

    private double goto(final double a2, final double a3) {
        double a4;
        BivariateEVDBilogistic a5;
        AbstractUnivariateRealFunction a6 = new AbstractUnivariateRealFunction(){
            {
                1 a32;
            }

            @Override
            public double evaluate(double z) {
                return BivariateEVDBilogistic.this.short(a2, a3, z);
            }
        };
        try {
            a4 = const.solve(a6, 0.0, 1.0, new double[0]);
        }
        catch (NoRootFoundException a7) {
            a4 = a7.x();
        }
        return a4;
    }

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.catch.nextDouble(), this.catch.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){
            {
                6 a32;
            }

            @Override
            public double evaluate(double x) {
                return BivariateEVDBilogistic.this.case(x, a3[1]) - a3[0];
            }
        };
        try {
            a2 = const.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.void.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.enum.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    private double case(double a2, double a3) {
        double a4;
        BivariateEVDBilogistic a5;
        final double a6 = -Math.log(a2);
        final double a7 = -Math.log(a3);
        AbstractUnivariateRealFunction a8 = new AbstractUnivariateRealFunction(){

            @Override
            public double evaluate(double x) {
                return (1.0 - BivariateEVDBilogistic.this.class) * a6 * Math.pow(1.0 - x, BivariateEVDBilogistic.this.goto) - (1.0 - BivariateEVDBilogistic.this.goto) * a7 * Math.pow(x, BivariateEVDBilogistic.this.class);
            }
            {
                5 a3;
            }
        };
        try {
            a4 = const.solve(a8, 0.0, 1.0, new double[0]);
        }
        catch (NoRootFoundException a9) {
            a4 = a9.x();
        }
        double a10 = a6 * Math.pow(a4, 1.0 - a5.class) + a7 * Math.pow(1.0 - a4, 1.0 - a5.goto);
        double a11 = Math.exp(-a10) * (1.0 / a3) * Math.pow(1.0 - a4, 1.0 - a5.goto);
        return a11;
    }

    private double short(double a2, double a3) {
        BivariateEVDBilogistic a4;
        return (1.0 - a4.class) * a2 * Math.pow(1.0 - a3, a4.goto) - (1.0 - a4.goto) * (1.0 - a2) * Math.pow(a3, a4.class);
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = this.do(x);
        return x * Math.pow(a2, 1.0 - this.class) + (1.0 - x) * Math.pow(1.0 - a2, 1.0 - this.goto);
    }

    private double do(final double a2, final double a3) {
        double a4;
        BivariateEVDBilogistic a5;
        if (a2 == 0.0) {
            return 0.0;
        }
        if (a3 == 0.0) {
            return 1.0;
        }
        if (Double.isInfinite(a2) || Double.isInfinite(a3)) {
            return 0.5;
        }
        AbstractUnivariateRealFunction a6 = new AbstractUnivariateRealFunction(){
            {
                2 a32;
            }

            @Override
            public double evaluate(double x) {
                return BivariateEVDBilogistic.this.do(a2, a3, x);
            }
        };
        try {
            a4 = const.solve(a6, 0.0, 1.0, new double[0]);
        }
        catch (NoRootFoundException a7) {
            a4 = a7.x();
        }
        return a4;
    }

    public BivariateEVDBilogistic(double alpha, double beta, GeneralizedEVD marginal) {
        this(alpha, beta, marginal, marginal);
    }
}

