/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.univariate;

import dev.nm.analysis.function.special.gamma.GammaRegularizedP;
import dev.nm.analysis.function.special.gamma.GammaRegularizedPInverse;
import dev.nm.analysis.function.special.gamma.LogGamma;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GammaDistribution
implements ProbabilityDistribution {
    private final double const;
    private static final GammaRegularizedPInverse void;
    private final double class;
    private static final GammaRegularizedP goto;
    private static final LogGamma enum;

    @Override
    public double cdf(double x) {
        assert (x >= 0.0) : "x must be non-negative";
        return goto.evaluate(this.const, x / this.class);
    }

    @Override
    public double moment(double t) {
        ArgumentAssertion.assertTrue(t < 1.0 / this.class, "only for t < 1/theta", new Object[0]);
        return Math.pow(1.0 - this.class * t, -this.const);
    }

    @Override
    public double variance() {
        return this.const * this.class * this.class;
    }

    @Override
    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.const < 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (DoubleUtils.isZero(x, 0.0) && this.const == 1.0) {
            return Math.exp(-enum.evaluate(this.const) - this.const * Math.log(this.class));
        }
        double a2 = (this.const - 1.0) * Math.log(x) - x / this.class - this.const * Math.log(this.class) - enum.evaluate(this.const);
        a2 = Math.exp(a2);
        return a2;
    }

    public GammaDistribution(double k2, double theta) {
        ArgumentAssertion.assertPositive(k2, "k");
        ArgumentAssertion.assertPositive(theta, "theta");
        this.const = k2;
        this.class = theta;
    }

    @Override
    public double median() {
        throw new UnsupportedOperationException("There is no simple closed form.");
    }

    static {
        enum = new LogGamma();
        goto = new GammaRegularizedP();
        void = new GammaRegularizedPInverse();
    }

    @Override
    @Deprecated
    public double entropy() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double skew() {
        return 2.0 / Math.sqrt(this.const);
    }

    @Override
    public double kurtosis() {
        return 6.0 / this.const;
    }

    @Override
    public double quantile(double u) {
        return this.class * void.evaluate(this.const, u);
    }

    @Override
    public double mean() {
        return this.const * this.class;
    }
}

