/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.distribution.multivariate;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.algebra.linear.matrix.doubles.operation.VariancebtX;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.stat.distribution.multivariate.MultivariateProbabilityDistribution;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MultivariateNormalDistribution
implements MultivariateProbabilityDistribution {
    private final double void;
    private final Matrix class;
    private final ImmutableMatrix goto;
    private final ImmutableVector enum;

    @Override
    public double density(Vector x) {
        Vector a2 = x.minus(this.enum);
        return this.void * Math.exp(-0.5 * a2.innerProduct(this.class.multiply(a2)));
    }

    @Override
    public double cdf(Vector x) {
        throw new UnsupportedOperationException("not yet supported");
    }

    @Override
    public Matrix covariance() {
        return new ImmutableMatrix(this.goto);
    }

    public MultivariateNormalDistribution(int dim) {
        this(new DenseVector(dim), (Matrix)new DenseMatrix(dim, dim).ONE());
    }

    @Override
    public double entropy() {
        int a2 = this.enum.size();
        double a3 = (double)a2 / 2.0 * (1.0 + Math.log(Math.PI * 2));
        return a3 += Math.log(MatrixMeasure.det(this.class)) / 2.0;
    }

    private double do() {
        MultivariateNormalDistribution a2;
        double a3 = MatrixMeasure.det(a2.goto);
        int a4 = a2.enum.size();
        double a5 = 1.0 / Math.sqrt(Math.pow(Math.PI * 2, a4) * a3);
        return a5;
    }

    public MultivariateNormalDistribution(Vector mu, Matrix Sigma) {
        ArgumentAssertion.assertTrue(mu.size() == Sigma.nCols() && Sigma.nCols() == Sigma.nRows(), "the size of the mean vector must match the size of the covariance matrix", new Object[0]);
        ArgumentAssertion.assertTrue(MatrixPropertyUtils.isSymmetric(Sigma, 0.0), "the covariance matrix must be symmetric", new Object[0]);
        this.enum = new ImmutableVector(mu);
        this.goto = new ImmutableMatrix(Sigma);
        this.class = new Inverse(Sigma);
        this.void = this.do();
    }

    @Override
    public Vector mean() {
        return this.enum;
    }

    @Override
    public double moment(Vector t) {
        double a2 = this.enum.innerProduct(t);
        return a2 += new VariancebtX(t, this.class).doubleValue();
    }

    @Override
    public Vector mode() {
        return this.enum;
    }
}

