/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.moment.weighted;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.number.doublearray.DoubleArrayOperation;
import dev.nm.number.doublearray.SimpleDoubleArrayOperation;
import dev.nm.stat.descriptive.Statistic;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WeightedMean
implements Statistic {
    private long void;
    private double class;
    private static DoubleArrayOperation goto = new SimpleDoubleArrayOperation();
    private double enum;

    @Override
    public void addData(double ... data) {
        ArgumentAssertion.assertTrue(data.length % 2 == 0, "there must be the same number of data points", new Object[0]);
        int a2 = data.length / 2;
        double[] a3 = Arrays.copyOfRange(data, 0, a2);
        double[] a4 = Arrays.copyOfRange(data, a2, data.length);
        this.do(a3, a4);
    }

    public WeightedMean(double[] data, double[] weights) {
        this.do(data, weights);
    }

    private void do(double[] a2, double[] a3) {
        WeightedMean a4;
        ArgumentAssertion.assertEqual(a2.length, a3.length, "number of data", "number of weights");
        if (a2.length == 0) {
            return;
        }
        double a5 = a4.enum * a4.class;
        a4.class += DoubleArrayMath.sum(a3);
        a4.void += (long)a2.length;
        a4.enum = (a5 += DoubleArrayMath.sum(goto.multiply(a2, a3))) / a4.class;
    }

    public double sumOfWeights() {
        return this.class;
    }

    public WeightedMean() {
    }

    public void addData(double[] data, double[] weights) {
        this.do(data, weights);
    }

    @Override
    public double value() {
        return this.enum;
    }

    @Override
    public long N() {
        return this.void;
    }
}

