/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.covariance.covarianceselection.lasso;

import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.cholesky.Chol;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.Inverse;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixMeasure;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.covariance.covarianceselection.CovarianceSelectionProblem;
import dev.nm.stat.covariance.covarianceselection.CovarianceSelectionSolver;
import dev.nm.stat.regression.linear.lasso.ConstrainedLASSOProblem;
import dev.nm.stat.regression.linear.lasso.ConstrainedLASSObyLARS;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CovarianceSelectionLASSO
implements CovarianceSelectionSolver {
    private final CovarianceSelectionProblem goto;
    private final double enum;

    public CovarianceSelectionLASSO(CovarianceSelectionProblem problem) {
        this(problem, PrecisionUtils.autoEpsilon(problem.S()));
    }

    @Override
    public Matrix covariance() {
        ImmutableMatrix a2 = this.goto.S();
        double a3 = this.goto.t();
        int a4 = a2.nCols();
        Matrix a5 = null;
        Matrix a6 = a2.add(((DenseMatrix)new DenseMatrix(a4, a4).ONE()).scaled(1.0E-8));
        int a7 = 0;
        while (a5 == null || !this.do(a5, a6, this.enum)) {
            a5 = a6.deepCopy();
            for (int a8 = 1; a8 <= a4; ++a8) {
                Matrix a9 = MatrixFactory.minorMatrix(a5, a8, a8);
                Vector a10 = this.do(a2.getColumn(a8), a8);
                LowerTriangularMatrix a11 = new Chol(a9).L();
                Inverse a12 = new Inverse(a11);
                LowerTriangularMatrix a13 = a11;
                Vector a14 = a12.multiply(a10);
                ConstrainedLASSOProblem a15 = new ConstrainedLASSOProblem(a14, (Matrix)a13, a3);
                ImmutableVector a16 = new ConstrainedLASSObyLARS(a15).beta().betaHat();
                Vector a17 = a9.multiply(a16);
                for (int a18 = 1; a18 <= a4 - 1; ++a18) {
                    int a19 = a18 < a8 ? 0 : 1;
                    a6.set(a8, a18 + a19, a17.get(a18));
                    a6.set(a18 + a19, a8, a17.get(a18));
                }
            }
            ++a7;
        }
        return a5;
    }

    private Vector do(Vector a2, final int a3) {
        CovarianceSelectionLASSO a4;
        Vector a5 = VectorFactory.subVector(a2, DoubleUtils.select(DoubleUtils.seq(1, a2.size()), new DoubleUtils.which(){
            {
                1 a32;
            }

            @Override
            public boolean isTrue(double x, int index) {
                return index + 1 != a3;
            }
        }));
        return a5;
    }

    public CovarianceSelectionProblem problem() {
        return this.goto;
    }

    private boolean do(Matrix a2, Matrix a3, double a4) {
        Matrix a5 = a2.minus(a3);
        boolean a6 = MatrixMeasure.Frobenius(a5) < a4;
        return a6;
    }

    @Override
    public Matrix inverseCovariance() {
        Matrix a2 = this.covariance();
        return new Inverse(a2);
    }

    static {
        Package.validate("NMDEV_COVARIANCE_SELECTION_LASSO");
    }

    public CovarianceSelectionLASSO(CovarianceSelectionProblem problem, double epsilon) {
        this.goto = problem;
        this.enum = epsilon;
    }
}

