/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.unconstrained.annealing;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.misc.algorithm.stopcondition.StopCondition;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.multivariate.unconstrained.IterativeMinimizer;
import dev.nm.solver.multivariate.unconstrained.annealing.acceptanceprobabilityfunction.MetropolisAcceptanceProbabilityFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.acceptanceprobabilityfunction.TemperedAcceptanceProbabilityFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.annealingfunction.AnnealingFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.annealingfunction.BoltzAnnealingFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.temperaturefunction.BoltzTemperatureFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.temperaturefunction.TemperatureFunction;
import dev.nm.solver.problem.OptimProblem;
import dev.nm.stat.random.rng.univariate.BernoulliTrial;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.normal.Zignor2005;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SimulatedAnnealingMinimizer
implements IterativeMinimizer<OptimProblem> {
    private final RandomLongGenerator catch;
    private final AnnealingFunction const;
    private final TemperatureFunction void;
    private final TemperedAcceptanceProbabilityFunction class;
    private final StopCondition goto;
    private final int enum;

    @Override
    public IterativeSolution<Vector> solve(final OptimProblem problem) throws Exception {
        final RealScalarFunction a2 = problem.f();
        return new IterativeSolution<Vector>(){
            private Vector goto = null;
            Vector currentState;
            private int enum = 0;
            double bestEnergy;
            double currentEnergy;
            Vector bestState;

            @Override
            public double minimum() {
                double a22 = (Double)problem.f().evaluate(this.minimizer());
                return a22;
            }
            {
                1 a3;
            }

            @Override
            public Object step() throws Exception {
                double a22 = SimulatedAnnealingMinimizer.this.void.visitingTemperature(this.enum);
                double a3 = SimulatedAnnealingMinimizer.this.void.acceptanceTemperature(this.enum);
                for (int a4 = 0; a4 < SimulatedAnnealingMinimizer.this.enum; ++a4) {
                    Vector a5 = SimulatedAnnealingMinimizer.this.const.nextProposal(this.currentState, a22);
                    double a6 = (Double)a2.evaluate(a5);
                    double a7 = SimulatedAnnealingMinimizer.this.class.acceptanceProbability(this.currentState, this.currentEnergy, a5, a6, a3);
                    if (!BernoulliTrial.nextTrial(SimulatedAnnealingMinimizer.this.catch, a7)) continue;
                    this.currentState = a5;
                    this.currentEnergy = a6;
                    if (!(this.currentEnergy < this.bestEnergy)) continue;
                    this.bestState = this.currentState;
                    this.bestEnergy = this.currentEnergy;
                }
                return this.bestState;
            }

            @Override
            public Vector minimizer() {
                if (this.goto == null) {
                    try {
                        this.search(this.currentState);
                    }
                    catch (Exception a22) {
                        this.goto = null;
                    }
                }
                return this.goto;
            }

            public Vector search(Vector ... initials) throws Exception {
                this.setInitials(initials);
                this.enum = 0;
                while (!SimulatedAnnealingMinimizer.this.goto.isStopped(this.bestState, this.bestEnergy)) {
                    this.step();
                    ++this.enum;
                }
                this.goto = this.bestState;
                return this.goto;
            }

            public void setInitials(Vector ... initials) {
                this.currentState = initials[0];
                this.currentEnergy = (Double)a2.evaluate(this.currentState);
                this.bestState = this.currentState;
                this.bestEnergy = this.currentEnergy;
            }
        };
    }

    public SimulatedAnnealingMinimizer(int dim, double initialTemperature, StopCondition stopCondition, RandomLongGenerator uniform) {
        this(new BoltzTemperatureFunction(initialTemperature), new BoltzAnnealingFunction(dim, new Zignor2005(uniform)), new MetropolisAcceptanceProbabilityFunction(), dim, stopCondition, uniform);
    }

    public SimulatedAnnealingMinimizer(TemperatureFunction temperatureFunction, AnnealingFunction annealingFunction, TemperedAcceptanceProbabilityFunction probabilityFunction, int markovLength, StopCondition stopCondition, RandomLongGenerator uniform) {
        this.void = temperatureFunction;
        this.const = annealingFunction;
        this.class = probabilityFunction;
        this.enum = markovLength;
        this.goto = stopCondition;
        this.catch = uniform;
    }
}

