/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.root.univariate;

import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.root.univariate.UnivariateMinimizer;
import dev.nm.solver.problem.C2OptimProblem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GridSearchMinimizer
implements UnivariateMinimizer {
    private static final ParallelExecutor goto = new ParallelExecutor(GridSearchMinimizer.class.getSimpleName());
    private final GridDefinition enum;

    @Override
    public Solution solve(UnivariateRealFunction f2) {
        return new Solution(f2);
    }

    public GridSearchMinimizer(GridDefinition gridDefinition) {
        this.enum = gridDefinition;
    }

    @Override
    public Solution solve(C2OptimProblem problem) {
        return this.solve((UnivariateRealFunction)problem.f());
    }

    public GridSearchMinimizer(int nPoints) {
        this((a3, a4) -> {
            double a5 = (a4 - a3) / (double)nPoints;
            return DoubleUtils.seq(a3, a4, a5);
        });
        ArgumentAssertion.assertPositive(nPoints, "no. of grid points");
    }

    public GridSearchMinimizer(double gridSize) {
        this((a3, a4) -> DoubleUtils.seq(a3, a4, gridSize));
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Solution
    implements UnivariateMinimizer.Solution {
        private final UnivariateRealFunction class;
        private double goto;
        private double enum;

        private Solution(UnivariateRealFunction a3) {
            Solution a4;
            a4.class = a3;
        }

        @Override
        public double search(double lower, double initial, double upper) {
            ArgumentAssertion.assertTrue(lower < upper, "invalid bracket interval", new Object[0]);
            this.goto = Double.POSITIVE_INFINITY;
            final double[] a2 = GridSearchMinimizer.this.enum.points(lower, upper);
            try {
                final double[] a3 = new double[a2.length];
                goto.forLoop(0, a2.length, new LoopBody(){
                    {
                        1 a32;
                    }

                    @Override
                    public void run(int i2) throws Exception {
                        double a22;
                        a3[i2] = a22 = Solution.this.class.evaluate(a2[i2]);
                    }
                });
                this.goto = DoubleArrayMath.min(a3);
                int a4 = DoubleUtils.minIndex(a3);
                this.enum = a2[a4];
            }
            catch (Exception a5) {
                for (double a6 : a2) {
                    double a7 = this.class.evaluate(a6);
                    if (!(a7 < this.goto)) continue;
                    this.goto = a7;
                    this.enum = a6;
                }
            }
            return this.enum;
        }

        @Override
        public double search(double lower, double upper) {
            return this.search(lower, Double.NaN, upper);
        }

        @Override
        public Double minimizer() {
            return this.enum;
        }

        @Override
        public double minimum() {
            return this.goto;
        }
    }

    public static interface GridDefinition {
        public double[] points(double var1, double var3);
    }
}

