/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentiation.univariate;

import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentiation.Ridders;
import dev.nm.analysis.differentiation.univariate.DBetaRegularized;
import dev.nm.analysis.differentiation.univariate.DErf;
import dev.nm.analysis.differentiation.univariate.DGamma;
import dev.nm.analysis.differentiation.univariate.DGaussian;
import dev.nm.analysis.differentiation.univariate.DPolynomial;
import dev.nm.analysis.differentiation.univariate.FiniteDifference;
import dev.nm.analysis.function.polynomial.Polynomial;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.special.beta.BetaRegularized;
import dev.nm.analysis.function.special.gamma.Digamma;
import dev.nm.analysis.function.special.gamma.Gamma;
import dev.nm.analysis.function.special.gamma.LogGamma;
import dev.nm.analysis.function.special.gaussian.Erf;
import dev.nm.analysis.function.special.gaussian.Gaussian;
import dev.nm.analysis.function.special.gaussian.StandardCumulativeNormal;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Dfdx
extends AbstractUnivariateRealFunction {
    private final UnivariateRealFunction enum;

    public Dfdx(final UnivariateRealFunction f2, Method method) {
        if (f2 instanceof Polynomial) {
            this.enum = new DPolynomial((Polynomial)f2);
        } else if (f2 instanceof BetaRegularized) {
            this.enum = new DBetaRegularized(((BetaRegularized)f2).p(), ((BetaRegularized)f2).q());
        } else if (f2 instanceof LogGamma) {
            this.enum = new Digamma();
        } else if (f2 instanceof Gamma) {
            this.enum = new DGamma();
        } else if (f2 instanceof StandardCumulativeNormal) {
            this.enum = new Gaussian();
        } else if (f2 instanceof Gaussian) {
            this.enum = new DGaussian((Gaussian)f2);
        } else if (f2 instanceof Erf) {
            this.enum = new DErf();
        } else {
            switch (method) {
                case RIDDERS: {
                    this.enum = new AbstractUnivariateRealFunction(){
                        private final RealScalarFunction enum;
                        {
                            1 a3;
                            a3.enum = new Ridders(a3.f2, 1);
                        }

                        @Override
                        public double evaluate(double x) {
                            return (Double)this.enum.evaluate(new DenseVector(x));
                        }
                    };
                    break;
                }
                default: {
                    this.enum = new FiniteDifference(f2, 1, FiniteDifference.Type.CENTRAL);
                }
            }
        }
    }

    @Override
    public double evaluate(double x) {
        return this.enum.evaluate(x);
    }

    public Dfdx(UnivariateRealFunction f2) {
        this(f2, Method.FINITE_DIFFERENCE);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Method {
        FINITE_DIFFERENCE,
        RIDDERS;


        private Method() {
            Method a2;
        }
    }
}

