/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentiation.multivariate;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentiation.multivariate.MultivariateFiniteDifference;
import dev.nm.analysis.function.rn2r1.R1Projection;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2rm.RealVectorFunction;
import java.util.List;

public class Jacobian
extends DenseMatrix {
    public Jacobian(RealVectorFunction f2, Vector x) {
        super(f2.dimensionOfRange(), f2.dimensionOfDomain());
        for (int a2 = 1; a2 <= this.nRows(); ++a2) {
            R1Projection a3 = new R1Projection(f2, a2);
            for (int a4 = 1; a4 <= this.nCols(); ++a4) {
                MultivariateFiniteDifference a5 = new MultivariateFiniteDifference(a3, new int[]{a4});
                super.set(a2, a4, a5.evaluate(x));
            }
        }
    }

    public Jacobian(final RealScalarFunction[] f2, Vector x) {
        this(new RealVectorFunction(){

            @Override
            public Vector evaluate(Vector x) {
                double[] a2 = new double[f2.length];
                for (int a3 = 0; a3 < f2.length; ++a3) {
                    double a4;
                    a2[a3] = a4 = ((Double)f2[a3].evaluate(x)).doubleValue();
                }
                return new DenseVector(a2);
            }

            @Override
            public int dimensionOfRange() {
                return f2.length;
            }
            {
                1 a2;
            }

            @Override
            public int dimensionOfDomain() {
                return f2[0].dimensionOfDomain();
            }
        }, (Vector)new DenseVector(x));
    }

    public Jacobian(List<RealScalarFunction> f2, Vector x) {
        this(f2.toArray(new RealScalarFunction[0]), x);
    }
}

