/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.heatequation;

import dev.nm.analysis.differentialequation.pde.PDE;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HeatEquation1D
implements PDE {
    private final double break;
    private final UnivariateRealFunction else;
    private final double catch;
    private final UnivariateRealFunction const;
    private final double void;
    private final UnivariateRealFunction class;
    private final double goto;
    private final double enum;

    public double beta() {
        return this.enum;
    }

    public double c2() {
        return this.break;
    }

    public HeatEquation1D(double beta, double a2, double T2, UnivariateRealFunction f2, double c1, UnivariateRealFunction g1, double c2, UnivariateRealFunction g2) {
        ArgumentAssertion.assertPositive(beta, "beta");
        ArgumentAssertion.assertPositive(a2, "a");
        ArgumentAssertion.assertPositive(T2, "T");
        ArgumentAssertion.assertRange(c1, 0.0, 1.0, "c1");
        ArgumentAssertion.assertRange(c2, 0.0, 1.0, "c2");
        this.enum = beta;
        this.goto = a2;
        this.void = T2;
        this.const = f2;
        this.catch = c1;
        this.else = g1;
        this.break = c2;
        this.class = g2;
    }

    public double c1() {
        return this.catch;
    }

    double g1(double a2) {
        HeatEquation1D a3;
        ArgumentAssertion.assertRange(a2, 0.0, a3.void, "t");
        return a3.else.evaluate(a2);
    }

    public double g2(double t) {
        ArgumentAssertion.assertRange(t, 0.0, this.void, "t");
        return this.class.evaluate(t);
    }

    public double f(double x) {
        ArgumentAssertion.assertRangeOpen(x, 0.0, this.goto, "x");
        return this.const.evaluate(x);
    }

    static {
        Package.validate("NMDEV_OPDE");
    }

    public double a() {
        return this.goto;
    }

    public double T() {
        return this.void;
    }
}

