/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.pde.finitedifference.hyperbolic.dim1;

import dev.nm.analysis.differentialequation.pde.PDE;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class WaveEquation1D
implements PDE {
    private final UnivariateRealFunction const;
    private final double void;
    private final double class;
    private final double goto;
    private final UnivariateRealFunction enum;

    public WaveEquation1D(double beta, double T2, double a2, UnivariateRealFunction f2, UnivariateRealFunction g2) {
        ArgumentAssertion.assertPositive(beta, "beta");
        ArgumentAssertion.assertPositive(T2, "T");
        ArgumentAssertion.assertPositive(a2, "a");
        this.class = beta;
        this.void = T2;
        this.goto = a2;
        this.enum = f2;
        this.const = g2;
    }

    public double beta() {
        return this.class;
    }

    static {
        Package.validate("NMDEV_OPDE");
    }

    public double g(double x) {
        ArgumentAssertion.assertRangeOpen(x, 0.0, this.goto, "x");
        return this.const.evaluate(x);
    }

    public double f(double x) {
        ArgumentAssertion.assertRangeOpen(x, 0.0, this.goto, "x");
        return this.enum.evaluate(x);
    }

    public double a() {
        return this.goto;
    }

    public double T() {
        return this.void;
    }
}

