/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.vector.doubles.operation;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.qr.HouseholderQR;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.OLSSolver;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.PrecisionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RealVectorSpace {
    private List<Vector> void;
    private int class;
    private final double goto;
    private List<Vector> enum = new ArrayList<Vector>();

    public RealVectorSpace(Vector ... elements) {
        this(Arrays.asList(elements));
    }

    public RealVectorSpace(Matrix A2, double epsilon) {
        this.void = new ArrayList<Vector>();
        this.goto = epsilon;
        this.do(A2);
    }

    public int rank() {
        return this.class;
    }

    public RealVectorSpace(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(MatrixUtils.to1DArray(A2)));
    }

    private void do(Matrix a2) {
        Vector a3;
        int a4;
        RealVectorSpace a5;
        HouseholderQR a6 = new HouseholderQR(a2, a5.goto);
        Matrix a7 = a6.squareQ();
        a5.class = a6.rank();
        for (a4 = 1; a4 <= a5.class; ++a4) {
            a3 = a7.getColumn(a4);
            a3 = a3.scaled(1.0 / a3.norm());
            a5.enum.add(a3);
        }
        for (a4 = a5.class + 1; a4 <= a7.nCols(); ++a4) {
            a3 = a7.getColumn(a4);
            a3 = a3.scaled(1.0 / a3.norm());
            a5.void.add(a3);
        }
    }

    @Deprecated
    public boolean isInKernel(Vector b2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Vector getSpanningCoefficients(Vector b2) {
        Vector a2 = null;
        try {
            Matrix a3 = MatrixFactory.cbind(this.enum);
            OLSSolver a4 = new OLSSolver(this.goto);
            a2 = a4.solve(new LSProblem(a3, b2));
            Vector a5 = a3.multiply(a2);
            if (!MatrixPropertyUtils.areEqual(a5, b2, this.goto)) {
                a2 = null;
            }
        }
        catch (Exception a6) {
            a2 = null;
        }
        return a2;
    }

    public List<Vector> getComplement() {
        return Collections.unmodifiableList(this.void);
    }

    public RealVectorSpace(List<Vector> elements, double epsilon) {
        this(MatrixFactory.cbind(elements), epsilon);
    }

    public RealVectorSpace(double epsilon, Vector ... elements) {
        this(Arrays.asList(elements), epsilon);
    }

    public boolean isSpanned(Vector b2) {
        Vector a2 = this.getSpanningCoefficients(b2);
        return a2 != null;
    }

    @Deprecated
    public Vector getLinearSpan(double ... d2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public RealVectorSpace(List<Vector> elements) {
        this(MatrixFactory.cbind(elements));
    }

    public List<Vector> getBasis() {
        return Collections.unmodifiableList(this.enum);
    }
}

