/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.generic.matrixtype;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.generic.GenericMatrix;
import dev.nm.algebra.structure.Field;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import java.lang.reflect.Array;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GenericFieldMatrix<F extends Field<F>>
implements GenericMatrix<GenericFieldMatrix<F>, F> {
    private final F void;
    private F[][] class;
    private final int goto;
    private final int enum;

    @Override
    public int nRows() {
        return this.enum;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericFieldMatrix a2 = (GenericFieldMatrix)obj;
        if (!DimensionCheck.isSameDimension(this, a2)) {
            return false;
        }
        return this.class == a2.class || this.class != null && a2.class != null && this.do((Field[][])a2.class);
    }

    @Override
    public GenericFieldMatrix<F> multiply(GenericFieldMatrix<F> that) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)this, that);
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.enum, that.goto, (Field)this.void.ZERO());
        for (int a3 = 0; a3 < this.enum; ++a3) {
            for (int a4 = 0; a4 < that.goto; ++a4) {
                Field a5 = (Field)this.void.ZERO();
                for (int a6 = 0; a6 < this.goto; ++a6) {
                    Field a7 = (Field)this.class[a3][a6].multiply(that.class[a6][a4]);
                    a5 = a5.add(a7);
                }
                a2.class[a3][a4] = a5;
            }
        }
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> scaled(F scalar) {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.enum, this.goto, (Field)this.void.ZERO());
        for (int a3 = 0; a3 < this.enum; ++a3) {
            for (int a4 = 0; a4 < this.goto; ++a4) {
                a2.class[a3][a4] = (Field)this.class[a3][a4].multiply(scalar);
            }
        }
        return a2;
    }

    public GenericFieldMatrix(F[][] data) {
        this.enum = data.length;
        this.goto = data[0].length;
        this.void = (Field)data[0][0].ZERO();
        this.class = (Field[][])Array.newInstance(this.void.getClass(), this.enum, this.goto);
        for (int a2 = 0; a2 < this.enum; ++a2) {
            if (data[a2].length != this.goto) {
                this.class = null;
                throw new IllegalArgumentException("data is a jagged array");
            }
            for (int a3 = 0; a3 < this.goto; ++a3) {
                this.class[a2][a3] = data[a2][a3];
            }
        }
    }

    public GenericFieldMatrix(int nRows, int nCols, F init) {
        this.enum = nRows;
        this.goto = nCols;
        this.void = init;
        this.class = (Field[][])Array.newInstance(init.getClass(), nRows, nCols);
        for (int a2 = 0; a2 < nRows; ++a2) {
            for (int a3 = 0; a3 < nCols; ++a3) {
                this.class[a2][a3] = init;
            }
        }
    }

    @Override
    public void set(int row, int col, F value) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        this.class[row - 1][col - 1] = value;
    }

    public String toString() {
        int a2;
        StringBuilder a3 = new StringBuilder();
        a3.append(String.format("%dx%d\n", this.enum, this.goto));
        a3.append("\t");
        for (a2 = 1; a2 <= this.goto; ++a2) {
            a3.append(String.format("[,%d] ", a2));
        }
        a3.append("\n");
        for (a2 = 1; a2 <= this.enum; ++a2) {
            a3.append(String.format("[%d,] ", a2));
            for (int a4 = 1; a4 <= this.goto; ++a4) {
                a3.append(String.format("%s, ", this.get(a2, a4).toString()));
            }
            a3.append("\n");
        }
        return a3.toString();
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 61 * a2 + this.enum;
        a2 = 61 * a2 + this.goto;
        a2 = 61 * a2 + Arrays.deepHashCode(this.class);
        a2 = 61 * a2 + (this.void != null ? this.void.hashCode() : 0);
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> opposite() {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.enum, this.goto, (Field)this.void.ZERO());
        for (int a3 = 0; a3 < this.enum; ++a3) {
            for (int a4 = 0; a4 < this.goto; ++a4) {
                a2.class[a3][a4] = (Field)this.class[a3][a4].opposite();
            }
        }
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> minus(GenericFieldMatrix<F> that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.enum, this.goto, (Field)this.void.ZERO());
        for (int a3 = 0; a3 < this.enum; ++a3) {
            for (int a4 = 0; a4 < this.goto; ++a4) {
                a2.class[a3][a4] = (Field)this.class[a3][a4].minus(that.class[a3][a4]);
            }
        }
        return a2;
    }

    private boolean do(F[][] a2) {
        GenericFieldMatrix a3;
        for (int a4 = 0; a4 < a3.enum; ++a4) {
            for (int a5 = 0; a5 < a3.goto; ++a5) {
                if (a3.class[a4][a5].equals(a2[a4][a5])) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public GenericFieldMatrix<F> ZERO() {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.enum, this.goto, (Field)this.void.ZERO());
        return a2;
    }

    @Override
    public F get(int row, int col) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        return this.class[row - 1][col - 1];
    }

    @Override
    public int nCols() {
        return this.goto;
    }

    @Override
    public GenericFieldMatrix<F> ONE() {
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.enum, this.goto, (Field)this.void.ZERO());
        for (int a3 = 0; a3 < this.enum; ++a3) {
            a2.class[a3][a3] = (Field)this.void.ONE();
        }
        return a2;
    }

    @Override
    public GenericFieldMatrix<F> add(GenericFieldMatrix<F> that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        GenericFieldMatrix<Field> a2 = new GenericFieldMatrix<Field>(this.enum, this.goto, (Field)this.void.ZERO());
        for (int a3 = 0; a3 < this.enum; ++a3) {
            for (int a4 = 0; a4 < this.goto; ++a4) {
                a2.class[a3][a4] = (Field)this.class[a3][a4].add(that.class[a3][a4]);
            }
        }
        return a2;
    }
}

