/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.nonstationary;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.ConvergenceFailure;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.IterativeLinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.IdentityPreconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.Preconditioner;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.solver.iterative.preconditioner.PreconditionerFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.algorithm.iterative.monitor.IterationMonitor;
import dev.nm.misc.algorithm.iterative.monitor.NullMonitor;
import dev.nm.misc.algorithm.iterative.tolerance.Tolerance;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GeneralizedConjugateResidualSolver
implements IterativeLinearSystemSolver {
    private final Tolerance void;
    private final int class;
    private final PreconditionerFactory goto;
    private final int enum;

    public IterativeLinearSystemSolver.Solution solve(LSProblem problem) throws ConvergenceFailure {
        return this.solve(problem, new NullMonitor<Vector>());
    }

    public GeneralizedConjugateResidualSolver(int m2, int maxIteration, Tolerance tolerance) {
        this(new PreconditionerFactory(){
            {
                1 a2;
            }

            @Override
            public Preconditioner newInstance(Matrix A2) {
                return new IdentityPreconditioner();
            }
        }, m2, maxIteration, tolerance);
    }

    public GeneralizedConjugateResidualSolver(int maxIteration, Tolerance tolerance) {
        this(Integer.MAX_VALUE, maxIteration, tolerance);
    }

    public GeneralizedConjugateResidualSolver(PreconditionerFactory leftPreconditionerFactory, int m2, int maxIteration, Tolerance tolerance) {
        this.goto = leftPreconditionerFactory;
        this.enum = m2;
        this.class = maxIteration;
        this.void = tolerance;
    }

    @Override
    public IterativeLinearSystemSolver.Solution solve(final LSProblem problem, final IterationMonitor<Vector> monitor) throws ConvergenceFailure {
        return new IterativeLinearSystemSolver.Solution(){
            private final Preconditioner final;
            private Vector break;
            private int else;
            private Vector catch;
            private final int const;
            private final Vector void;
            private final Matrix class;
            private boolean goto;
            private final int enum;

            public void setInitials(Vector ... initials) {
                this.break = initials[0];
                this.catch = this.void.minus(this.class.multiply(this.break));
                this.goto = GeneralizedConjugateResidualSolver.this.void.isResidualSmall(this.catch.norm());
            }
            {
                2 a3;
                a3.class = a3.problem.A();
                a3.void = a3.problem.b();
                a3.const = a3.GeneralizedConjugateResidualSolver.this.enum >= a3.problem.A().nCols() ? Math.min(a3.problem.getMaxIteration(), a3.problem.A().nCols()) : a3.GeneralizedConjugateResidualSolver.this.class;
                a3.final = a3.GeneralizedConjugateResidualSolver.this.goto.newInstance(a3.class);
                a3.enum = Math.min(a3.GeneralizedConjugateResidualSolver.this.enum, a3.class.nCols());
                a3.else = 0;
            }

            @Override
            public IterationMonitor<Vector> step() throws ConvergenceFailure {
                Vector a2 = this.final.solve(this.catch);
                Vector[] a3 = new Vector[this.enum + 1];
                Vector[] a4 = new Vector[this.enum];
                double[] a5 = new double[this.enum];
                a3[0] = a2.scaled(1.0 / a2.norm());
                int a6 = 1;
                while (a6 <= this.enum && this.else < this.const && !this.goto) {
                    monitor.addIterate(this.break);
                    Vector a7 = this.class.multiply(a3[a6 - 1]);
                    a4[a6 - 1] = this.final.solve(a7);
                    a5[a6 - 1] = a4[a6 - 1].innerProduct(a4[a6 - 1]);
                    if (Double.compare(a5[a6 - 1], 0.0) == 0) {
                        throw new ConvergenceFailure(ConvergenceFailure.Reason.BREAKDOWN, "<w, w> = 0");
                    }
                    double a8 = this.catch.innerProduct(a4[a6 - 1]) / a5[a6 - 1];
                    this.break = this.break.add(a3[a6 - 1].scaled(a8));
                    this.catch = this.catch.minus(a4[a6 - 1].scaled(a8));
                    Vector a9 = this.class.multiply(this.catch);
                    Vector a10 = this.final.solve(a9);
                    a3[a6] = this.catch;
                    for (int a11 = 0; a11 < a6; ++a11) {
                        double a12 = -a10.innerProduct(a4[a11]) / a5[a11];
                        a3[a6] = a3[a6].add(a3[a11].scaled(a12));
                    }
                    ++a6;
                    ++this.else;
                    this.goto = GeneralizedConjugateResidualSolver.this.void.isResidualSmall(this.catch.norm());
                }
                this.catch = this.void.minus(this.class.multiply(this.break));
                return monitor;
            }

            @Override
            public Vector search(Vector ... initials) throws ConvergenceFailure {
                this.setInitials(initials);
                while (this.else < this.const && !this.goto) {
                    this.step();
                    this.goto |= GeneralizedConjugateResidualSolver.this.void.isResidualSmall(this.catch.norm());
                }
                monitor.addIterate(this.break);
                if (!this.goto) {
                    throw new ConvergenceFailure(ConvergenceFailure.Reason.MAX_ITERATIONS_EXCEEDED, this.const + " iterations exceeded");
                }
                return this.break;
            }
        };
    }
}

