/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.sparse.SparseStructure;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.number.Real;
import dev.nm.number.doublearray.DoubleArrayMath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SparseVector
implements Vector,
SparseStructure,
Iterable<Entry> {
    private final Map<Integer, Entry> goto = new HashMap<Integer, Entry>();
    private final int enum;

    @Override
    public double angle(Vector that) {
        double a2 = this.innerProduct(that);
        a2 /= this.norm();
        a2 /= that.norm();
        a2 = Math.acos(a2);
        return a2;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public double innerProduct(Vector that) {
        if (that instanceof SparseVector) {
            return this.innerProduct((SparseVector)that);
        }
        return this.do(that);
    }

    private double do(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        double a4 = 0.0;
        for (Entry a5 : a3.goto.values()) {
            a4 += a5.enum * a2.get(a5.goto);
        }
        return a4;
    }

    public SparseVector(Vector v) {
        this.enum = v.size();
        for (int a2 = 1; a2 <= this.enum; ++a2) {
            double a3 = v.get(a2);
            if (a3 == 0.0) continue;
            Entry a4 = new Entry(a2, a3);
            this.goto.put(a4.goto, a4);
        }
    }

    @Override
    public SparseVector deepCopy() {
        return new SparseVector(this);
    }

    @Override
    public Vector add(double c2) {
        double[] a2 = DoubleUtils.rep(c2, this.enum);
        for (Entry a3 : this.goto.values()) {
            int n = a3.goto - 1;
            a2[n] = a2[n] + a3.enum;
        }
        return new DenseVector(a2);
    }

    @Override
    public SparseVector ZERO() {
        return new SparseVector(this.enum);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!SparseVector.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Vector)obj, 0.0);
        }
        SparseVector a2 = (SparseVector)obj;
        if (this.enum != a2.enum) {
            return false;
        }
        return Objects.equals(this.goto, a2.goto);
    }

    @Override
    public void set(int index, double value) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, index);
        if (value == 0.0) {
            this.goto.remove(index);
        } else {
            this.goto.put(index, new Entry(index, value));
        }
    }

    @Override
    public java.util.Iterator<Entry> iterator() {
        return new Iterator(this.goto.values().iterator());
    }

    @Override
    public Vector pow(double c2) {
        double a2 = Math.pow(0.0, c2);
        if (Double.compare(0.0, a2) != 0) {
            double[] a3 = DoubleUtils.rep(a2, this.enum);
            for (Entry a4 : this.goto.values()) {
                a3[((Entry)a4).goto - 1] = Math.pow(a4.enum, c2);
            }
            return new DenseVector(a3);
        }
        SparseVector a5 = new SparseVector(this.enum);
        for (Entry a6 : this.goto.values()) {
            a5.set(a6.goto, Math.pow(a6.enum, c2));
        }
        return a5;
    }

    @Override
    public int nNonZeros() {
        return this.goto.size();
    }

    public SparseVector(int size, Collection<Entry> entries) {
        this.enum = size;
        for (Entry a2 : entries) {
            if (this.goto.containsKey(a2.goto)) {
                throw new IllegalArgumentException("duplicated indices: " + a2.goto);
            }
            this.goto.put(a2.goto, a2);
        }
    }

    public SparseVector multiply(SparseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        SparseVector a2 = new SparseVector(this.enum);
        for (Entry a3 : this) {
            double a4;
            int a5 = a3.goto;
            Entry a6 = that.goto.get(a5);
            if (a6 == null || (a4 = a3.enum * a6.enum) == 0.0) continue;
            a2.goto.put(a5, new Entry(a5, a4));
        }
        return a2;
    }

    private static List<Entry> do(int a2, int[] a3, double[] a4) {
        ArgumentAssertion.assertTrue(a3.length == a4.length, "sizes of input arrays mismatch", new Object[0]);
        ArrayList<Entry> a5 = new ArrayList<Entry>();
        for (int a6 = 0; a6 < a4.length; ++a6) {
            if (a3[a6] < 1 || a3[a6] > a2) {
                throw new IndexOutOfBoundsException("out-of-range index: " + a3[a6]);
            }
            a5.add(new Entry(a3[a6], a4[a6]));
        }
        return a5;
    }

    @Override
    public Vector minus(Vector that) {
        if (that instanceof SparseVector) {
            return this.minus((SparseVector)that);
        }
        return this.do(that);
    }

    @Override
    public SparseVector multiply(Vector that) {
        if (that instanceof SparseVector) {
            return this.multiply((SparseVector)that);
        }
        return this.do(that);
    }

    @Override
    public SparseVector opposite() {
        return this.scaled(-1.0);
    }

    private SparseVector do(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        SparseVector a4 = new SparseVector(a3);
        for (Entry a5 : a3) {
            int a6 = a5.goto;
            double a7 = a5.enum * a2.get(a6);
            if (a7 == 0.0) {
                a4.goto.remove(a6);
                continue;
            }
            a4.set(a6, a7);
        }
        return a4;
    }

    @Override
    public int size() {
        return this.enum;
    }

    public int hashCode() {
        int a2 = 5;
        a2 = 59 * a2 + this.enum;
        a2 = 59 * a2 + (this.goto != null ? this.goto.hashCode() : 0);
        return a2;
    }

    @Override
    public Vector add(Vector that) {
        if (that instanceof SparseVector) {
            return this.add((SparseVector)that);
        }
        return this.short(that);
    }

    @Override
    public double innerProduct(SparseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        double a2 = 0.0;
        for (Entry a3 : this) {
            a2 += a3.enum * that.get(a3.goto);
        }
        return a2;
    }

    public Vector leftMultiply(Matrix A2) {
        double[] a2 = new double[A2.nRows()];
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (Entry a4 : this.goto.values()) {
                int n = a3 - 1;
                a2[n] = a2[n] + a4.enum * A2.get(a3, a4.goto);
            }
        }
        return new DenseVector(a2);
    }

    @Override
    public double norm(double p) {
        if (p == Double.POSITIVE_INFINITY) {
            return DoubleArrayMath.max(DoubleArrayMath.abs(this.toArray()));
        }
        if (p == Double.NEGATIVE_INFINITY) {
            return DoubleArrayMath.min(DoubleArrayMath.abs(this.toArray()));
        }
        ArgumentAssertion.assertNotLessThan(p, 1.0, "p");
        double a2 = 0.0;
        for (Entry a3 : this.goto.values()) {
            a2 += Math.pow(a3.value(), p);
        }
        a2 = Math.pow(a2, 1.0 / p);
        return a2;
    }

    @Override
    public double[] toArray() {
        double[] a2 = new double[this.enum];
        for (Entry a3 : this.goto.values()) {
            a2[((Entry)a3).goto - 1] = a3.enum;
        }
        return a2;
    }

    public SparseVector(SparseVector that) {
        this(that.enum);
        that.goto.values().forEach(a2 -> {
            SparseVector a3;
            a3.goto.put(((Entry)a2).goto, new Entry(((Entry)a2).goto, ((Entry)a2).enum));
        });
    }

    public SparseVector(double ... v) {
        this.enum = v.length;
        for (int a2 = 0; a2 < this.enum; ++a2) {
            if (v[a2] == 0.0) continue;
            Entry a3 = new Entry(a2 + 1, v[a2]);
            this.goto.put(a3.goto, a3);
        }
    }

    public SparseVector(int size, int[] indices, double[] values) {
        this(size, SparseVector.do(size, indices, values));
    }

    @Override
    public double norm() {
        return this.norm(2.0);
    }

    public String toString() {
        StringBuilder a2 = new StringBuilder();
        a2.append("size: ").append(this.enum).append(System.lineSeparator());
        ArrayList<Entry> a3 = new ArrayList<Entry>(this.goto.values());
        Collections.sort(a3, Entry.BY_INDEX);
        for (Entry a4 : a3) {
            a2.append(a4.toString()).append(System.lineSeparator());
        }
        return a2.toString();
    }

    @Override
    public SparseVector add(SparseVector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        SparseVector a2 = new SparseVector(this.enum, this.goto.values());
        for (Entry a3 : that) {
            int a4 = a3.goto;
            Entry a5 = this.goto.get(a4);
            if (a5 == null) {
                a2.goto.put(a4, a3);
                continue;
            }
            double a6 = a5.enum + a3.enum;
            if (a6 == 0.0) {
                a2.goto.remove(a4);
                continue;
            }
            a2.goto.put(a4, new Entry(a4, a6));
        }
        return a2;
    }

    @Override
    public double get(int index) {
        MatrixPropertyUtils.throwIfInvalidIndex(this, index);
        Entry a2 = this.goto.get(index);
        return a2 != null ? a2.enum : 0.0;
    }

    @Override
    public Vector minus(double c2) {
        return this.add(-c2);
    }

    @Override
    public SparseVector scaled(double c2) {
        if (Double.compare(0.0, c2) == 0) {
            return new SparseVector(this.enum);
        }
        SparseVector a2 = new SparseVector(this.enum);
        for (Entry a3 : this.goto.values()) {
            a2.set(a3.goto, c2 * a3.enum);
        }
        return a2;
    }

    private Vector short(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        DenseVector a4 = new DenseVector(a2);
        for (Entry a5 : a3.goto.values()) {
            a4.set(a5.goto, a5.enum + a4.get(a5.goto));
        }
        return a4;
    }

    @Override
    public SparseVector minus(SparseVector that) {
        return this.add(that.opposite());
    }

    public SparseVector(int size) {
        this.enum = size;
    }

    @Override
    public Vector divide(Vector that) {
        MatrixPropertyUtils.throwIfNotEqualSize(this, that);
        SparseVector a2 = new SparseVector(this);
        for (Entry a3 : a2.goto.values()) {
            a2.set(a3.goto, a3.enum / that.get(a3.goto));
        }
        return a2;
    }

    @Override
    public SparseVector scaled(Real c2) {
        return this.scaled(c2.doubleValue());
    }

    private Vector do(Vector a2) {
        SparseVector a3;
        MatrixPropertyUtils.throwIfNotEqualSize(a3, a2);
        Object a4 = a2.opposite();
        for (Entry a5 : a3.goto.values()) {
            a4.set(a5.goto, a5.enum + a4.get(a5.goto));
        }
        return a4;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Iterator
    implements java.util.Iterator<Entry> {
        private final java.util.Iterator<Entry> enum;

        @Override
        public boolean hasNext() {
            return this.enum.hasNext();
        }

        @Override
        public Entry next() {
            return this.enum.next();
        }

        private Iterator(java.util.Iterator<Entry> a2) {
            Iterator a3;
            a3.enum = a2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("cannot remove an element in a vector; set it to zero instead");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Entry {
        public static final Comparator<Entry> BY_INDEX = (a2, a3) -> Integer.compare(a2.goto, a3.goto);
        private int goto;
        private double enum;

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry a2 = (Entry)obj;
            if (this.goto != a2.goto) {
                return false;
            }
            return Double.doubleToLongBits(this.enum) == Double.doubleToLongBits(a2.enum);
        }

        public String toString() {
            return String.format("[%d] %.4f", this.goto, this.enum);
        }

        public int index() {
            return this.goto;
        }

        public Entry(int index, double value) {
            this.goto = index;
            this.enum = value;
        }

        public double value() {
            return this.enum;
        }

        public int hashCode() {
            int a2 = 3;
            a2 = 59 * a2 + this.goto;
            a2 = 59 * a2 + (int)(Double.doubleToLongBits(this.enum) ^ Double.doubleToLongBits(this.enum) >>> 32);
            return a2;
        }
    }
}

