/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.misc.datastructure.Table;
import dev.nm.misc.license.Package;

public class SimpleMatrixMathOperation
implements MatrixMathOperation {
    static {
        Package.validate("NMDEV_BASIC");
    }

    @Override
    public Matrix transpose(MatrixAccess A2) {
        DenseMatrix a2 = new DenseMatrix(A2.nCols(), A2.nRows());
        for (int a3 = 1; a3 <= A2.nCols(); ++a3) {
            for (int a4 = 1; a4 <= A2.nRows(); ++a4) {
                a2.set(a3, a4, A2.get(a4, a3));
            }
        }
        return a2;
    }

    @Override
    public Matrix add(MatrixAccess A1, MatrixAccess A2) {
        DimensionCheck.throwIfDifferentDimension(A1, A2);
        DenseMatrix a2 = new DenseMatrix(A1.nRows(), A1.nCols());
        for (int a3 = 1; a3 <= A1.nRows(); ++a3) {
            for (int a4 = 1; a4 <= A1.nCols(); ++a4) {
                a2.set(a3, a4, A1.get(a3, a4) + A2.get(a3, a4));
            }
        }
        return a2;
    }

    @Override
    public Vector multiply(MatrixAccess A2, Vector v) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)A2, v);
        DenseVector a2 = new DenseVector(A2.nRows());
        for (int a3 = 1; a3 <= a2.size(); ++a3) {
            double a4 = 0.0;
            for (int a5 = 1; a5 <= v.size(); ++a5) {
                a4 += A2.get(a3, a5) * v.get(a5);
            }
            a2.set(a3, a4);
        }
        return a2;
    }

    @Override
    public Matrix scaled(MatrixAccess A2, double scalar) {
        DenseMatrix a2 = new DenseMatrix(A2.nRows(), A2.nCols());
        for (int a3 = 1; a3 <= A2.nRows(); ++a3) {
            for (int a4 = 1; a4 <= A2.nCols(); ++a4) {
                a2.set(a3, a4, A2.get(a3, a4) * scalar);
            }
        }
        return a2;
    }

    @Override
    public Matrix minus(MatrixAccess A1, MatrixAccess A2) {
        DimensionCheck.throwIfDifferentDimension(A1, A2);
        DenseMatrix a2 = new DenseMatrix(A1.nRows(), A1.nCols());
        for (int a3 = 1; a3 <= A1.nRows(); ++a3) {
            for (int a4 = 1; a4 <= A1.nCols(); ++a4) {
                a2.set(a3, a4, A1.get(a3, a4) - A2.get(a3, a4));
            }
        }
        return a2;
    }

    @Override
    public Matrix multiply(MatrixAccess A1, MatrixAccess A2) {
        DimensionCheck.throwIfIncompatible4Multiplication((Table)A1, A2);
        int a2 = A1.nRows();
        int a3 = A2.nCols();
        DenseMatrix a4 = new DenseMatrix(a2, a3);
        int a5 = A1.nCols();
        double[] a6 = new double[a5 + 1];
        for (int a7 = 1; a7 <= a3; ++a7) {
            int a8;
            for (a8 = 1; a8 <= a5; ++a8) {
                a6[a8] = A2.get(a8, a7);
            }
            for (a8 = 1; a8 <= a2; ++a8) {
                double a9 = 0.0;
                for (int a10 = 1; a10 <= a5; ++a10) {
                    a9 += A1.get(a8, a10) * a6[a10];
                }
                a4.set(a8, a7, a9);
            }
        }
        return a4;
    }
}

