/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseData;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.TriangularDataAccessUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.number.doublearray.DoubleArrayOperation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UpperTriangularMatrix
implements Matrix,
Densifiable {
    private final int class;
    private final MyDenseData goto;
    private static final MatrixMathOperation enum = new AutoParallelMatrixMathOperation();

    public int hashCode() {
        int a2 = 3;
        a2 = 31 * a2 + (this.goto != null ? this.goto.hashCode() : 0);
        a2 = 31 * a2 + this.class;
        return a2;
    }

    @Override
    public int nCols() {
        return this.class;
    }

    @Override
    public Vector getColumn(int j2) {
        if (j2 < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (j2 > this.nCols()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a2 = this.goto.asArray();
        double[] a3 = new double[this.nRows()];
        int a4 = 0;
        int a5 = j2 - 1;
        while (a4 < j2) {
            a3[a4] = a2[a5];
            a5 += this.nCols() - ++a4;
        }
        return new DenseVector(a3);
    }

    @Override
    public DenseMatrix toDense() {
        double[] a2 = this.goto.asArray();
        int a3 = 0;
        double[] a4 = new double[this.nRows() * this.nCols()];
        int a5 = 1;
        int a6 = 0;
        while (a6 < a4.length) {
            for (int a7 = 0; a7 <= this.nCols() - a5; ++a7) {
                a4[a6 + a7] = a2[a3++];
            }
            a6 += this.nCols() + 1;
            ++a5;
        }
        return new DenseMatrix(a4, this.nRows(), this.nCols());
    }

    @Override
    public UpperTriangularMatrix scaled(double scalar) {
        return new UpperTriangularMatrix((MyDenseData)this.goto.scaled(scalar));
    }

    @Override
    public int nRows() {
        return this.class;
    }

    @Override
    public UpperTriangularMatrix ZERO() {
        UpperTriangularMatrix a2 = new UpperTriangularMatrix(this.class);
        return a2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!UpperTriangularMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        UpperTriangularMatrix a2 = (UpperTriangularMatrix)obj;
        if (this.class != a2.class) {
            return false;
        }
        return this.goto == a2.goto || this.goto != null && this.goto.equals(a2.goto);
    }

    public String toString() {
        return MatrixUtils.toString(this);
    }

    public UpperTriangularMatrix(int dim) {
        this(new MyDenseData(dim));
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof UpperTriangularMatrix) {
            return new UpperTriangularMatrix((MyDenseData)this.goto.minus(((UpperTriangularMatrix)that).goto));
        }
        return enum.minus(this, that);
    }

    @Override
    public UpperTriangularMatrix opposite() {
        return this.scaled(-1.0);
    }

    @Override
    public UpperTriangularMatrix deepCopy() {
        return new UpperTriangularMatrix(this);
    }

    public UpperTriangularMatrix(double[][] data) {
        this(data[0].length);
        for (int a2 = 1; a2 <= this.class; ++a2) {
            if (data[a2 - 1].length == this.class - a2 + 1) continue;
            throw new IllegalArgumentException("data set is not upper triangular");
        }
        double[] a3 = this.goto.asArray();
        int a4 = 0;
        for (int a5 = 0; a5 < this.class; ++a5) {
            int a6 = this.class - a5;
            for (int a7 = 0; a7 < a6; ++a7) {
                a3[a4++] = data[a5][a7];
            }
        }
    }

    @Override
    public Matrix multiply(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (!(that instanceof UpperTriangularMatrix)) {
            return enum.multiply((MatrixAccess)this, that);
        }
        MyDenseData a2 = this.goto;
        MyDenseData a3 = ((UpperTriangularMatrix)that).goto;
        UpperTriangularMatrix a4 = new UpperTriangularMatrix(this.class);
        MyDenseData a5 = a4.goto;
        for (int a6 = 1; a6 <= this.class; ++a6) {
            for (int a7 = a6; a7 <= this.class; ++a7) {
                double a8 = 0.0;
                for (int a9 = a6; a9 <= a7; ++a9) {
                    a8 += a2.get(a6, a9) * a3.get(a9, a7);
                }
                a5.set(a6, a7, a8);
            }
        }
        return a4;
    }

    @Override
    public LowerTriangularMatrix t() {
        double[] a2 = new double[this.goto.asArray().length];
        double[] a3 = this.goto.asArray();
        int a4 = 0;
        for (int a5 = 0; a5 < this.nCols(); ++a5) {
            int a6 = 0;
            int a7 = 0;
            while (a6 <= a5) {
                a2[a4++] = a3[a5 + a7];
                a7 += this.nRows() - ++a6;
            }
        }
        return new LowerTriangularMatrix(a2, this.class);
    }

    @Override
    public UpperTriangularMatrix ONE() {
        UpperTriangularMatrix a2 = new UpperTriangularMatrix(this.class);
        for (int a3 = 1; a3 <= this.class; ++a3) {
            a2.set(a3, a3, 1.0);
        }
        return a2;
    }

    @Override
    public Vector getRow(int i2) {
        if (i2 < 1) {
            throw new IllegalArgumentException("row/col counts from 1");
        }
        if (i2 > this.nRows()) {
            throw new IllegalArgumentException("invalid index");
        }
        double[] a2 = new double[this.nCols()];
        int a3 = (i2 - 1) * this.nCols();
        if (i2 >= 3) {
            a3 -= (i2 - 1) * (i2 - 2) >> 1;
        }
        int a4 = i2 - 1;
        int a5 = this.nCols() - a4;
        System.arraycopy(this.goto.asArray(), a3, a2, a4, a5);
        return new DenseVector(a2);
    }

    public UpperTriangularMatrix(Matrix A2) {
        this(A2.nRows());
        if (!DimensionCheck.isSquare(A2)) {
            throw new IllegalArgumentException("a upper triangular matrix must be square");
        }
        for (int a2 = 1; a2 <= this.class; ++a2) {
            for (int a3 = a2; a3 <= this.class; ++a3) {
                this.set(a2, a3, A2.get(a2, a3));
            }
        }
    }

    @Override
    public Vector multiply(Vector v) {
        return enum.multiply((MatrixAccess)this, v);
    }

    private UpperTriangularMatrix(MyDenseData a2) {
        UpperTriangularMatrix a3;
        a3.goto = a2;
        a3.class = a2.nRows();
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof UpperTriangularMatrix) {
            return new UpperTriangularMatrix((MyDenseData)this.goto.add(((UpperTriangularMatrix)that).goto));
        }
        return enum.add(this, that);
    }

    UpperTriangularMatrix(double[] a2, int a3) {
        a4(new MyDenseData(a2, a3));
        UpperTriangularMatrix a4;
    }

    public UpperTriangularMatrix(UpperTriangularMatrix U) {
        this((MyDenseData)U.goto.deepCopy());
    }

    @Override
    public void set(int i2, int j2, double value) throws MatrixAccessException {
        this.goto.set(i2, j2, value);
    }

    @Override
    public double get(int i2, int j2) throws MatrixAccessException {
        return this.goto.get(i2, j2);
    }

    private static final class MyDenseData
    extends DenseData {
        private MyDenseData(double[] a2, int a3) {
            super(a2, a3, a3);
            MyDenseData a4;
        }

        private MyDenseData(int a2) {
            a3(new double[TriangularDataAccessUtils.dataLength(a2)], a2);
            MyDenseData a3;
        }

        @Override
        protected MyDenseData newInstance(double[] data, int nRows, int nCols, DoubleArrayOperation operation) {
            return new MyDenseData(data, nRows, operation);
        }

        @Override
        public int position(int nRows, int nCols, int i2, int j2) {
            if (i2 <= j2) {
                int a2 = (((nCols << 1) - i2 + 2) * (i2 - 1) >> 1) + (j2 - i2);
                return a2;
            }
            return -1;
        }

        private MyDenseData(double[] a2, int a3, DoubleArrayOperation a4) {
            super(a2, a3, a3, a4);
            MyDenseData a5;
        }
    }
}

