/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle;

import dev.nm.algebra.linear.matrix.MatrixAccessException;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixAccess;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.Densifiable;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.AutoParallelMatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.mathoperation.MatrixMathOperation;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixUtils;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.misc.datastructure.DimensionCheck;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SymmetricMatrix
implements Matrix,
Densifiable {
    private final LowerTriangularMatrix class;
    private final int goto;
    private static final MatrixMathOperation enum = new AutoParallelMatrixMathOperation();

    @Override
    public SymmetricMatrix ZERO() {
        SymmetricMatrix a2 = new SymmetricMatrix(this.class.ZERO());
        return a2;
    }

    public SymmetricMatrix(int dim) {
        this(new LowerTriangularMatrix(dim));
    }

    @Override
    public void set(int row, int col, double value) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, row);
        DimensionCheck.throwIfInvalidColumn(this, col);
        if (row < col) {
            this.class.set(col, row, value);
        } else {
            this.class.set(row, col, value);
        }
    }

    @Override
    public Vector getRow(int i2) throws MatrixAccessException {
        int a2;
        DimensionCheck.throwIfInvalidRow(this, i2);
        double[] a3 = this.class.getRow(i2).toArray();
        double[] a4 = this.class.getColumn(i2).toArray();
        double[] a5 = new double[this.goto];
        int a6 = 0;
        for (a2 = 0; a2 < i2 - 1; ++a2) {
            a5[a6++] = a3[a2];
        }
        for (a2 = i2 - 1; a2 < this.goto; ++a2) {
            a5[a6++] = a4[a2];
        }
        return new DenseVector(a5);
    }

    public SymmetricMatrix(Matrix A2, boolean copyLower) {
        this(copyLower ? SymmetricMatrix.short(A2) : SymmetricMatrix.do(A2));
    }

    private static double[][] short(Matrix a2) {
        int a3 = a2.nRows();
        double[][] a4 = new double[a3][];
        for (int a5 = 0; a5 < a3; ++a5) {
            a4[a5] = new double[a5 + 1];
            for (int a6 = 0; a6 <= a5; ++a6) {
                a4[a5][a6] = a2.get(a5 + 1, a6 + 1);
            }
        }
        return a4;
    }

    @Override
    public int nCols() {
        return this.goto;
    }

    @Override
    public int nRows() {
        return this.goto;
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof SymmetricMatrix) {
            SymmetricMatrix a2 = new SymmetricMatrix((LowerTriangularMatrix)this.class.minus(((SymmetricMatrix)that).class));
            return a2;
        }
        return enum.minus(this, that);
    }

    @Override
    public SymmetricMatrix ONE() {
        SymmetricMatrix a2 = new SymmetricMatrix((LowerTriangularMatrix)this.class.ONE());
        return a2;
    }

    public String toString() {
        return MatrixUtils.toString(this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!MatrixAccess.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (!SymmetricMatrix.class.isAssignableFrom(obj.getClass())) {
            return MatrixPropertyUtils.areEqual(this, (Matrix)obj, 0.0);
        }
        SymmetricMatrix a2 = (SymmetricMatrix)obj;
        if (this.goto != a2.goto) {
            return false;
        }
        return this.class == a2.class || this.class != null && this.class.equals(a2.class);
    }

    @Override
    public Matrix multiply(Matrix that) {
        return enum.multiply((MatrixAccess)this, that);
    }

    public SymmetricMatrix(double[][] data) {
        this(new LowerTriangularMatrix(data));
    }

    @Override
    public SymmetricMatrix scaled(double scalar) {
        SymmetricMatrix a2 = new SymmetricMatrix((LowerTriangularMatrix)this.class.scaled(scalar));
        return a2;
    }

    @Override
    public SymmetricMatrix opposite() {
        return this.scaled(-1.0);
    }

    public int hashCode() {
        int a2 = 3;
        a2 = 17 * a2 + this.goto;
        a2 = 17 * a2 + (this.class != null ? this.class.hashCode() : 0);
        return a2;
    }

    @Override
    public DenseMatrix toDense() {
        DenseMatrix a2 = this.class.toDense();
        for (int a3 = 1; a3 <= this.goto; ++a3) {
            for (int a4 = a3 + 1; a4 <= this.goto; ++a4) {
                a2.set(a3, a4, this.class.get(a4, a3));
            }
        }
        return a2;
    }

    @Override
    public Vector multiply(Vector v) {
        return enum.multiply((MatrixAccess)this, v);
    }

    @Override
    public SymmetricMatrix t() {
        return new SymmetricMatrix(this);
    }

    public SymmetricMatrix(Matrix A2) {
        this(A2, false);
    }

    private static double[][] do(Matrix a2) {
        int a3 = a2.nRows();
        double[][] a4 = new double[a3][];
        for (int a5 = 0; a5 < a3; ++a5) {
            a4[a5] = new double[a5 + 1];
            int a6 = 0;
            while (a6 <= a5) {
                a4[a5][a6] = a2.get(a5 + 1, a6 + 1);
                double[] dArray = a4[a5];
                int n = a6;
                dArray[n] = dArray[n] + a2.get(a6 + 1, a5 + 1);
                double[] dArray2 = a4[a5];
                int n2 = a6++;
                dArray2[n2] = dArray2[n2] / 2.0;
            }
        }
        return a4;
    }

    private SymmetricMatrix(LowerTriangularMatrix a2) {
        SymmetricMatrix a3;
        a3.goto = a2.nRows();
        a3.class = a2;
    }

    @Override
    public SymmetricMatrix deepCopy() {
        return new SymmetricMatrix(this);
    }

    @Override
    public double get(int i2, int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidRow(this, i2);
        DimensionCheck.throwIfInvalidColumn(this, j2);
        if (i2 < j2) {
            return this.class.get(j2, i2);
        }
        return this.class.get(i2, j2);
    }

    public SymmetricMatrix(SymmetricMatrix S) {
        this((LowerTriangularMatrix)S.class.deepCopy());
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof SymmetricMatrix) {
            SymmetricMatrix a2 = new SymmetricMatrix((LowerTriangularMatrix)this.class.add(((SymmetricMatrix)that).class));
            return a2;
        }
        return enum.add(this, that);
    }

    @Override
    public Vector getColumn(int j2) throws MatrixAccessException {
        DimensionCheck.throwIfInvalidColumn(this, j2);
        return this.getRow(j2);
    }
}

