/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalData;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.DiagonalDataMatrix;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.number.DoubleUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TridiagonalMatrix
extends DiagonalDataMatrix {
    private TridiagonalMatrix(DiagonalData a2) {
        super(a2);
        TridiagonalMatrix a3;
    }

    @Override
    public TridiagonalMatrix ZERO() {
        return new TridiagonalMatrix(this.storage.dim);
    }

    private static DiagonalData do(Matrix a2) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(a2), "A must be square", new Object[0]);
        int a3 = a2.nRows();
        if (a3 == 1) {
            return new DiagonalData(new double[][]{null, {a2.get(1, 1)}, null});
        }
        return new DiagonalData(new double[][]{VectorFactory.superDiagonal(a2).toArray(), VectorFactory.diagonal(a2).toArray(), VectorFactory.subDiagonal(a2).toArray()});
    }

    private static DiagonalData do(double[][] a2) {
        if (a2.length != 3) {
            throw new IllegalArgumentException("tri-diagonal matrix data must have 3 rows");
        }
        int a3 = 0;
        if (a2[0] != null) {
            a3 = a2[0].length + 1;
        } else if (a2[1] != null) {
            a3 = a2[1].length;
        } else if (a2[2] != null) {
            a3 = a2[2].length + 1;
        } else {
            throw new IllegalArgumentException("there must be at least one non-null row");
        }
        double[][] a4 = new double[][]{a2[0] != null ? a2[0] : DoubleUtils.rep(0.0, a3 - 1), a2[1] != null ? a2[1] : DoubleUtils.rep(0.0, a3), a2[2] != null ? a2[2] : DoubleUtils.rep(0.0, a3 - 1)};
        return new DiagonalData(a4);
    }

    @Override
    public TridiagonalMatrix opposite() {
        return this.scaled(-1.0);
    }

    public TridiagonalMatrix(int dim) {
        this(new DiagonalData(DiagonalData.Type.TRI_DIAGONAL, dim));
    }

    public TridiagonalMatrix(double[][] data) {
        this(TridiagonalMatrix.do(data));
    }

    @Override
    public TridiagonalMatrix t() {
        double[][] a2 = new double[][]{this.storage.getSubDiagonal(), this.storage.getDiagonal(), this.storage.getSuperDiagonal()};
        TridiagonalMatrix a3 = new TridiagonalMatrix(a2);
        return a3;
    }

    public TridiagonalMatrix(TridiagonalMatrix that) {
        this(new DiagonalData(that.storage));
    }

    public TridiagonalMatrix(Matrix A2) {
        this(TridiagonalMatrix.do(A2));
    }

    @Override
    public TridiagonalMatrix scaled(double scalar) {
        DiagonalData a2 = this.storage.scaled(scalar);
        TridiagonalMatrix a3 = new TridiagonalMatrix(a2);
        return a3;
    }

    @Override
    public TridiagonalMatrix ONE() {
        double[][] a2 = new double[3][];
        int a3 = this.storage.dim;
        a2[0] = DoubleUtils.rep(0.0, a3 - 1);
        a2[1] = DoubleUtils.rep(1.0, a3);
        a2[2] = DoubleUtils.rep(0.0, a3 - 1);
        TridiagonalMatrix a4 = new TridiagonalMatrix(a2);
        return a4;
    }

    @Override
    public Matrix minus(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof TridiagonalMatrix) {
            DiagonalData a2 = this.storage.minus(((TridiagonalMatrix)that).storage);
            TridiagonalMatrix a3 = new TridiagonalMatrix(a2);
            return a3;
        }
        return super.minus(that);
    }

    @Deprecated
    private TridiagonalMatrix do(TridiagonalMatrix a2) {
        throw new UnsupportedOperationException("TridiagonalMatrices do not constitute a Monoid.");
    }

    @Override
    public Matrix add(Matrix that) {
        DimensionCheck.throwIfDifferentDimension(this, that);
        if (that instanceof TridiagonalMatrix) {
            DiagonalData a2 = this.storage.add(((TridiagonalMatrix)that).storage);
            TridiagonalMatrix a3 = new TridiagonalMatrix(a2);
            return a3;
        }
        return super.add(that);
    }

    @Override
    public TridiagonalMatrix deepCopy() {
        return new TridiagonalMatrix(this);
    }
}

