/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.linearsystem;

import dev.nm.algebra.linear.matrix.MatrixSingularityException;
import dev.nm.algebra.linear.matrix.doubles.ImmutableMatrix;
import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.triangle.LU;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.BackwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.ForwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LSProblem;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.LinearSystemSolver;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.LowerTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.vector.doubles.ImmutableVector;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.datastructure.DimensionCheck;

public class LUSolver {
    public Matrix solve(Matrix A2, Matrix B2) {
        LU a2 = new LU(A2);
        LowerTriangularMatrix a3 = a2.L();
        UpperTriangularMatrix a4 = a2.U();
        ForwardSubstitution a5 = new ForwardSubstitution();
        Matrix a6 = a5.solve(a3, a2.P().multiply(B2));
        BackwardSubstitution a7 = new BackwardSubstitution();
        Matrix a8 = a7.solve(a4, a6);
        return a8;
    }

    public Vector solve(LSProblem problem) {
        ImmutableMatrix a2 = problem.A();
        ImmutableVector a3 = problem.b();
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(a2), "A must be a square matrix", new Object[0]);
        try {
            LU a4 = new LU(a2, 0.0);
            LowerTriangularMatrix a5 = a4.L();
            UpperTriangularMatrix a6 = a4.U();
            PermutationMatrix a7 = a4.P();
            Vector a8 = a7.multiply(a3);
            ForwardSubstitution a9 = new ForwardSubstitution();
            Vector a10 = a9.solve(a5, a8);
            BackwardSubstitution a11 = new BackwardSubstitution();
            Vector a12 = a11.solve(a6, a10);
            return a12;
        }
        catch (MatrixSingularityException a13) {
            throw new LinearSystemSolver.NoSolution("no solution to this system of linear equations");
        }
    }
}

