/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.qr;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.qr.QRDecomposition;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.PermutationMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.Basis;
import dev.nm.algebra.linear.vector.doubles.operation.Projection;
import dev.nm.misc.PrecisionUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GramSchmidt
implements QRDecomposition {
    private PermutationMatrix break;
    private int else;
    private Matrix catch;
    private final int const;
    private final int void;
    private final double class;
    private UpperTriangularMatrix goto;
    private final DenseVector enum;

    public GramSchmidt(Matrix A2, boolean pad0Cols, double epsilon) {
        this.const = A2.nRows();
        this.void = A2.nCols();
        this.class = epsilon;
        this.goto = new UpperTriangularMatrix(this.void);
        this.goto.set(1, 1, 0.0);
        this.break = new PermutationMatrix(this.void);
        this.else = 0;
        this.enum = new DenseVector(this.const);
        Vector[] a2 = new Vector[this.void];
        a2[0] = new DenseVector(this.const);
        for (int a3 = 1; a3 <= this.void; ++a3) {
            Vector a4 = A2.getColumn(a3);
            for (int a5 = 1; a5 <= 2; ++a5) {
                for (int a6 = 1; a6 <= a3 - 1; ++a6) {
                    if (a2[a6 - 1] == null) continue;
                    Projection a7 = new Projection(a4, a2[a6 - 1]);
                    a4 = a7.getOrthogonalVector();
                    this.goto.set(a6, a3, a7.getProjectionLength(0) + this.goto.get(a6, a3));
                }
            }
            if (!MatrixPropertyUtils.isZero(a4, epsilon)) {
                double a8 = a4.norm();
                this.goto.set(a3, a3, a8);
                a2[a3 - 1] = a4.scaled(1.0 / a8);
                ++this.else;
                continue;
            }
            if (pad0Cols) {
                a2[a3 - 1] = this.enum;
            }
            this.goto.set(a3, a3, 0.0);
            this.break.moveColumn2End(a3);
        }
        this.catch = MatrixFactory.cbind(a2);
    }

    @Override
    public Matrix squareQ() {
        if (this.catch.nRows() == this.else) {
            if (this.catch.nCols() <= this.catch.nRows()) {
                return this.Q();
            }
            Matrix a2 = MatrixFactory.subMatrix(this.catch, 1, this.const, 1, this.const);
            return a2;
        }
        if (this.catch.nCols() > this.catch.nRows()) {
            Matrix a3 = MatrixFactory.subMatrix(this.catch, 1, this.const, 1, this.const);
            return a3;
        }
        ArrayList<Vector> a4 = new ArrayList<Vector>();
        for (int a5 = 1; a5 <= this.else; ++a5) {
            a4.add(this.catch.getColumn(a5));
        }
        List<Vector> a6 = Basis.getBasis(this.const, this.const);
        a4.addAll(a6);
        Matrix a7 = MatrixFactory.cbind(a4);
        GramSchmidt a8 = new GramSchmidt(a7, false, this.class);
        Matrix a9 = a8.Q();
        a9 = MatrixFactory.subMatrix(a9, 1, this.const, 1, this.const);
        return a9;
    }

    @Override
    public PermutationMatrix P() {
        return new PermutationMatrix(this.break);
    }

    public GramSchmidt(Matrix A2) {
        this(A2, true, PrecisionUtils.autoEpsilon(A2));
    }

    @Override
    public UpperTriangularMatrix R() {
        return new UpperTriangularMatrix(this.goto);
    }

    @Override
    public int rank() {
        return this.else;
    }

    @Override
    public Matrix tallR() {
        UpperTriangularMatrix a2 = this.R();
        if (this.const < this.void) {
            return MatrixFactory.subMatrix(a2, 1, this.const, 1, this.void);
        }
        Object a3 = new DenseMatrix(this.const, this.void).ZERO();
        MatrixFactory.replaceInPlace((Matrix)a3, 1, Math.min(this.void, this.const), 1, this.void, a2);
        return a3;
    }

    @Override
    public Matrix Q() {
        return this.catch.deepCopy();
    }
}

