/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.eigen;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.CharacteristicPolynomial;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.ComplexEigenvalueComparator;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenProperty;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenvectorByLookup;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenvectorBySystemOfEquations;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.EigenvectorProvider;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.RealEigenvalueComparator;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.Spectrum;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.mr3.SymmetricEigenByMR3;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.QRAlgorithm;
import dev.nm.algebra.linear.matrix.doubles.factorization.eigen.qr.SymmetricQRAlgorithm;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.SymmetricMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.PrecisionUtils;
import dev.nm.misc.datastructure.DimensionCheck;
import dev.nm.number.DoubleUtils;
import dev.nm.number.NumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Eigen
implements Spectrum {
    private final boolean class;
    private final double goto;
    private final SortedMap<Number, EigenProperty> enum;

    public EigenProperty getProperty(Number eigenvalue) {
        return (EigenProperty)this.enum.get(eigenvalue);
    }

    public Eigen(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2));
    }

    public EigenProperty getProperty(int i2) {
        return this.do(i2).getValue();
    }

    public List<Number> getEigenvalues() {
        ArrayList<Number> a2 = new ArrayList<Number>(this.enum.keySet());
        return a2;
    }

    public Eigen(Matrix A2, double epsilon) {
        this(A2, Method.QR, epsilon);
    }

    public Number getEigenvalue(int i2) {
        return this.do(i2).getKey();
    }

    public Eigen(Matrix A2, Method method) {
        this(A2, method, PrecisionUtils.autoEpsilon(A2));
    }

    public double[] getRealEigenvalues() {
        if (this.class) {
            return DoubleUtils.collection2DoubleArray(this.enum.keySet());
        }
        ArrayList<Number> a2 = new ArrayList<Number>();
        for (Number a3 : this.enum.keySet()) {
            if (!NumberUtils.isReal(a3)) continue;
            a2.add(a3);
        }
        Collections.sort(a2, new RealEigenvalueComparator(this.goto));
        return DoubleUtils.collection2DoubleArray(a2);
    }

    private Map.Entry<Number, EigenProperty> do(int a2) {
        Eigen a3;
        Iterator<Map.Entry<Number, EigenProperty>> a4 = a3.enum.entrySet().iterator();
        for (int a5 = 0; a5 < a2; ++a5) {
            a4.next();
        }
        return a4.next();
    }

    /*
     * WARNING - void declaration
     */
    public Eigen(Matrix A2, Method method, double epsilon) {
        ArgumentAssertion.assertTrue(DimensionCheck.isSquare(A2), "eigen decomposition applies only to square matrix", new Object[0]);
        EigenProvider a2 = method.newProvider(A2, epsilon);
        Spectrum a3 = a2.getSpectrum();
        List<Number> a4 = a3.getEigenvalues();
        this.class = Eigen.do(a4);
        Comparator<Number> a5 = this.class ? new RealEigenvalueComparator(epsilon) : new ComplexEigenvalueComparator(epsilon);
        TreeMap<Number, Integer> a6 = new TreeMap<Number, Integer>(a5);
        for (Number a7 : a4) {
            void var12_11;
            Integer n = (Integer)a6.get(a7);
            if (n == null) {
                Integer n2 = 0;
            }
            a6.put(a7, var12_11.intValue() + 1);
        }
        this.enum = new TreeMap<Number, EigenProperty>(a5);
        EigenvectorProvider a9 = a2.getEigenvectorProvider();
        for (Map.Entry entry : a6.entrySet()) {
            Number a10 = (Number)entry.getKey();
            Integer a11 = (Integer)entry.getValue();
            this.enum.put(a10, new EigenProperty(a10, a11, a9));
        }
        this.goto = epsilon;
    }

    private static boolean do(List<Number> a2) {
        for (Number a3 : a2) {
            if (NumberUtils.isReal(a3)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.enum.size();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum Method {
        CHARACTERISTIC_POLYNOMIAL{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                1 a4;
                return new EigenProvider(){
                    private final EigenvectorProvider goto;
                    private final Spectrum enum;

                    @Override
                    public Spectrum getSpectrum() {
                        return this.enum;
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.goto;
                    }
                    {
                        Method.1 a32;
                        a32.enum = new CharacteristicPolynomial(a32.a2);
                        a32.goto = new EigenvectorBySystemOfEquations(a32.a2, a32.a3);
                    }
                };
            }
            {
                1 a2;
            }
        }
        ,
        MR3{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                2 a4;
                return new EigenProvider(){
                    private final EigenvectorProvider goto;
                    private final SymmetricEigenByMR3 enum;

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.goto;
                    }
                    {
                        Method.1 a32;
                        a32.enum = new SymmetricEigenByMR3(a32.a2, true, a32.a3);
                        a32.goto = new EigenvectorByLookup(a32.enum.getEigenvalues(), new EigenvectorByLookup.EigenvectorListProvider(){

                            @Override
                            public List<Vector> getAllEigenvectors() {
                                return a32.enum.getEigenvectors();
                            }
                            {
                                Method.1 a3;
                            }
                        }, a32.a3);
                    }

                    @Override
                    public Spectrum getSpectrum() {
                        return this.enum;
                    }
                };
            }
            {
                2 a2;
            }
        }
        ,
        QR_SYMMETRIC{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                3 a4;
                return new EigenProvider(){
                    private final EigenvectorProvider goto;
                    private final SymmetricQRAlgorithm enum;

                    @Override
                    public Spectrum getSpectrum() {
                        return this.enum;
                    }
                    {
                        Method.1 a32;
                        a32.enum = new SymmetricQRAlgorithm(a32.a2, a32.a3);
                        a32.goto = new EigenvectorByLookup(a32.enum.getEigenvalues(), new EigenvectorByLookup.EigenvectorListProvider(){

                            @Override
                            public List<Vector> getAllEigenvectors() {
                                return a32.enum.getEigenvectors();
                            }
                            {
                                Method.1 a3;
                            }
                        }, a32.a3);
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.goto;
                    }
                };
            }
            {
                3 a2;
            }
        }
        ,
        SYMMETRY{

            @Override
            EigenProvider newProvider(Matrix a2, double a3) {
                return MR3.newProvider(a2, a3);
            }
            {
                4 a2;
            }
        }
        ,
        QR{

            @Override
            EigenProvider newProvider(final Matrix a2, final double a3) {
                5 a4;
                if (MatrixPropertyUtils.isSymmetric(a2, 0.0)) {
                    Matrix a5 = a2 instanceof SymmetricMatrix ? a2 : new SymmetricMatrix(a2, true);
                    return QR_SYMMETRIC.newProvider(a5, a3);
                }
                return new EigenProvider(){
                    private final EigenvectorProvider goto;
                    private final Spectrum enum;

                    @Override
                    public Spectrum getSpectrum() {
                        return this.enum;
                    }

                    @Override
                    public EigenvectorProvider getEigenvectorProvider() {
                        return this.goto;
                    }
                    {
                        Method.1 a32;
                        a32.enum = new QRAlgorithm(a32.a2, a32.a3);
                        a32.goto = new EigenvectorBySystemOfEquations(a32.a2, a32.a3);
                    }
                };
            }
            {
                5 a2;
            }
        };


        private Method() {
            Method a2;
        }

        abstract EigenProvider newProvider(Matrix var1, double var2);
    }

    private static interface EigenProvider {
        public EigenvectorProvider getEigenvectorProvider();

        public Spectrum getSpectrum();
    }
}

