/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.algebra.linear.matrix.doubles.factorization.diagonalization;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.MatrixPropertyUtils;
import dev.nm.algebra.linear.matrix.doubles.factorization.diagonalization.BiDiagonalization;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.BidiagonalMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.misc.PrecisionUtils;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.random.rng.multivariate.IID;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BiDiagonalizationByGolubKahanLanczos
implements BiDiagonalization {
    private final double final;
    private BidiagonalMatrix break;
    private final RandomLongGenerator else;
    private final int catch;
    private final int const;
    private final Matrix void;
    private Matrix class;
    private Matrix goto;
    private final int enum;

    public BiDiagonalizationByGolubKahanLanczos(Matrix A2, RandomLongGenerator rlg) {
        this(A2, PrecisionUtils.autoEpsilon(A2), rlg);
    }

    @Override
    public Matrix V() {
        return this.class.deepCopy();
    }

    private Matrix short(Vector[] a2, int a3) {
        BiDiagonalizationByGolubKahanLanczos a4;
        ArrayList<Vector> a5 = new ArrayList<Vector>(a4.const);
        for (int a6 = 1; a6 < a3; ++a6) {
            a5.add(a2[a6]);
        }
        a4.do(a5, a4.const);
        return MatrixFactory.cbind(a5);
    }

    private void do() {
        int a2;
        BiDiagonalizationByGolubKahanLanczos a3;
        Matrix a4 = a3.void.t();
        Vector[] a5 = new Vector[a3.catch + 1];
        Vector[] a6 = new Vector[a3.catch + 2];
        a5[0] = new DenseVector(a3.const);
        a6[1] = a3.do();
        double[] a7 = new double[a3.catch + 1];
        double[] a8 = new double[a3.catch + 1];
        a7[0] = 0.0;
        boolean a9 = false;
        boolean a10 = false;
        for (a2 = 1; a2 <= a3.catch; ++a2) {
            a5[a2] = a3.void.multiply(a6[a2]).minus(a5[a2 - 1].scaled(a7[a2 - 1]));
            double a11 = a5[a2].norm();
            if (DoubleUtils.isZero(a11, a3.final)) {
                a9 = true;
                break;
            }
            a3.do(a5, a2);
            a8[a2] = a5[a2].norm();
            a5[a2] = a5[a2].scaled(1.0 / a8[a2]);
            a6[a2 + 1] = a4.multiply(a5[a2]).minus(a6[a2].scaled(a8[a2]));
            double a12 = a6[a2 + 1].norm();
            if (DoubleUtils.isZero(a12, a3.final)) {
                a10 = true;
                break;
            }
            a3.do(a6, a2 + 1);
            a7[a2] = a6[a2 + 1].norm();
            a6[a2 + 1] = a6[a2 + 1].scaled(1.0 / a7[a2]);
        }
        double[] a13 = Arrays.copyOfRange(a7, 1, a3.catch);
        double[] a14 = Arrays.copyOfRange(a8, 1, a3.catch + 1);
        a3.break = new BidiagonalMatrix(new double[][]{a13, a14});
        a3.goto = a3.short(a5, a9 ? a2 : (a10 ? a2 + 1 : a2));
        a3.class = a3.do(a6, a9 || a10 ? a2 + 1 : a2);
    }

    public BiDiagonalizationByGolubKahanLanczos(Matrix A2, double epsilon, RandomLongGenerator rlg) {
        this.void = A2;
        this.const = A2.nRows();
        this.enum = A2.nCols();
        this.catch = Math.min(this.const, this.enum);
        this.final = epsilon;
        this.else = rlg;
        if (MatrixPropertyUtils.isUpperBidiagonal(A2, epsilon)) {
            double[] a2 = VectorFactory.diagonal(A2).toArray();
            double[] a3 = this.enum > 1 ? VectorFactory.superDiagonal(A2).toArray() : null;
            this.break = new BidiagonalMatrix(new double[][]{a3, a2});
            this.goto = MatrixFactory.identity(this.const, this.const);
            this.class = MatrixFactory.identity(this.enum, this.enum);
        } else {
            this.do();
        }
    }

    private void do(Vector[] a2, int a3) {
        for (int a4 = 1; a4 < a3; ++a4) {
            a2[a3] = a2[a3].minus(a2[a4].scaled(a2[a3].innerProduct(a2[a4])));
        }
    }

    @Override
    public BidiagonalMatrix B() {
        return this.break.deepCopy();
    }

    public BiDiagonalizationByGolubKahanLanczos(Matrix A2) {
        this(A2, PrecisionUtils.autoEpsilon(A2), new UniformRNG(1234567890L));
    }

    @Override
    public Matrix U() {
        return this.goto.deepCopy();
    }

    private List<Vector> do(List<Vector> a2, int a3) {
        int a4 = a3 - a2.size();
        int a5 = 1;
        for (int a6 = 0; a6 < a4; ++a6) {
            boolean a7 = false;
            do {
                BiDiagonalizationByGolubKahanLanczos a8;
                Vector a9 = new DenseVector(a3);
                a9.set(a5++, 1.0);
                for (Vector a10 : a2) {
                    a9 = a9.minus(a10.scaled(a9.innerProduct(a10)));
                }
                if (DoubleUtils.isZero(a9.norm(), a8.final)) continue;
                a9 = a9.scaled(1.0 / a9.norm());
                a2.add(a9);
                a7 = true;
            } while (!a7 && a5 <= a3);
            if (a7) continue;
            throw new RuntimeException(String.format("failed to complete space of dimension %d", a3));
        }
        return a2;
    }

    private Vector do() {
        BiDiagonalizationByGolubKahanLanczos a2;
        IID a3 = new IID(a2.else, a2.enum);
        DenseVector a4 = new DenseVector(a3.nextVector());
        return a4.scaled(1.0 / a4.norm());
    }

    private Matrix do(Vector[] a2, int a3) {
        BiDiagonalizationByGolubKahanLanczos a4;
        ArrayList<Vector> a5 = new ArrayList<Vector>(a4.enum);
        for (int a6 = 1; a6 < a3; ++a6) {
            a5.add(a2[a6]);
        }
        a4.do(a5, a4.enum);
        return MatrixFactory.cbind(a5);
    }
}

