/*
 * Decompiled with CFR 0.152.
 */
package tech.nmfin.portfoliooptimization.corvalan2005;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.solver.IterativeSolution;
import dev.nm.solver.Minimizer;
import dev.nm.solver.multivariate.constrained.constraint.EqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.LessThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.general.GeneralEqualityConstraints;
import dev.nm.solver.multivariate.constrained.constraint.general.GeneralLessThanConstraints;
import dev.nm.solver.multivariate.constrained.general.penaltymethod.PenaltyMethodMinimizer;
import dev.nm.solver.multivariate.constrained.problem.ConstrainedOptimProblem;
import dev.nm.solver.multivariate.constrained.problem.ConstrainedOptimProblemImpl1;
import java.util.ArrayList;
import java.util.List;
import tech.nmfin.portfoliooptimization.corvalan2005.diversification.DiversificationMeasure;
import tech.nmfin.portfoliooptimization.corvalan2005.diversification.ProductOfWeights;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Corvalan2005 {
    private final Minimizer<? super ConstrainedOptimProblem, IterativeSolution<Vector>> false;
    private final DiversificationMeasure void;
    private final double if;
    private final double new;

    static {
        Package.validate("ALGOQUANT_CORVALAN2005");
    }

    public Corvalan2005(double deltaSigma, double deltaR) {
        this(new PenaltyMethodMinimizer(), new ProductOfWeights(), deltaSigma, deltaR);
    }

    public Corvalan2005(Minimizer<? super ConstrainedOptimProblem, IterativeSolution<Vector>> minimizer, DiversificationMeasure diversificationMeasure, double deltaSigma, double deltaR) {
        ArgumentAssertion.assertNonNegative(deltaSigma, "deltaSigma");
        ArgumentAssertion.assertNonNegative(deltaR, "deltaR");
        this.false = minimizer;
        this.void = diversificationMeasure;
        this.if = deltaSigma;
        this.new = deltaR;
    }

    private static LessThanConstraints final(LessThanConstraints a2) {
        if (a2 == null) {
            return null;
        }
        GeneralLessThanConstraints a3 = new GeneralLessThanConstraints(Corvalan2005.final(a2.getConstraints()));
        return a3;
    }

    private static LessThanConstraints final(LessThanConstraints ... a2) {
        ArrayList<RealScalarFunction> a3 = new ArrayList<RealScalarFunction>();
        for (LessThanConstraints a4 : a2) {
            if (a4 == null) continue;
            a3.addAll(a4.getConstraints());
        }
        if (a3.isEmpty()) {
            return null;
        }
        GeneralLessThanConstraints a5 = new GeneralLessThanConstraints(a3);
        return a5;
    }

    private LessThanConstraints final(int a2, Vector a3, final Matrix a4, final Vector a5) {
        Corvalan2005 a6;
        final double a7 = a3.innerProduct(a5);
        final double a8 = Math.sqrt(a3.innerProduct(a4.multiply(a3)));
        AbstractRealScalarFunction a9 = new AbstractRealScalarFunction(a2 - 1){

            @Override
            public Double evaluate(Vector w0) {
                Vector a2 = Corvalan2005.final(w0);
                double a3 = Math.sqrt(a2.innerProduct(a4.multiply(a2)));
                double a42 = a3 - a8 * (1.0 + Corvalan2005.this.if);
                return a42;
            }
            {
                2 a42;
                super(a3);
            }
        };
        AbstractRealScalarFunction a10 = new AbstractRealScalarFunction(a2 - 1){

            @Override
            public Double evaluate(Vector w0) {
                Vector a2 = Corvalan2005.final(w0);
                double a3 = a2.innerProduct(a5);
                double a4 = a7 * (1.0 - Corvalan2005.this.new) - a3;
                return a4;
            }
            {
                3 a4;
                super(a3);
            }
        };
        ArrayList<RealScalarFunction> a11 = new ArrayList<RealScalarFunction>(2);
        a11.add(a9);
        a11.add(a10);
        GeneralLessThanConstraints a12 = new GeneralLessThanConstraints(a11);
        return a12;
    }

    private static double final(double[] a2) {
        return 1.0 - DoubleArrayMath.sum(a2);
    }

    private RealScalarFunction final(int a2) {
        Corvalan2005 a3;
        AbstractRealScalarFunction a4 = new AbstractRealScalarFunction(a2 - 1){
            {
                1 a4;
                super(a3);
            }

            @Override
            public Double evaluate(Vector w) {
                double[] a2 = Corvalan2005.final(w.toArray());
                double a3 = -Corvalan2005.this.void.value(a2);
                return a3;
            }
        };
        return a4;
    }

    private static List<RealScalarFunction> final(List<RealScalarFunction> a2) {
        ArrayList<RealScalarFunction> a3 = new ArrayList<RealScalarFunction>(a2.size());
        for (final RealScalarFunction a4 : a2) {
            AbstractRealScalarFunction a5 = new AbstractRealScalarFunction(a4.dimensionOfDomain() - 1){
                {
                    4 a3;
                    super(a2);
                }

                @Override
                public Double evaluate(Vector w) {
                    return (Double)a4.evaluate(Corvalan2005.final(w));
                }
            };
            a3.add(a5);
        }
        return a3;
    }

    private static double[] final(double[] a2) {
        double[] a3 = new double[a2.length + 1];
        a3[0] = Corvalan2005.final(a2);
        System.arraycopy(a2, 0, a3, 1, a2.length);
        return a3;
    }

    public Vector getDiversifiedWeights(WeightsConstraint constraint, Vector weights0, Matrix sigma, Vector r, EqualityConstraints extraEqualityConstraints, LessThanConstraints extraLessThanConstraints) throws Exception {
        int a2 = weights0.size();
        LessThanConstraints a3 = Corvalan2005.final(constraint.constraints());
        LessThanConstraints a4 = this.final(a2, weights0, sigma, r);
        LessThanConstraints a5 = Corvalan2005.final(extraLessThanConstraints);
        LessThanConstraints a6 = Corvalan2005.final(a3, a4, a5);
        ConstrainedOptimProblemImpl1 a7 = new ConstrainedOptimProblemImpl1(this.final(a2), Corvalan2005.final(extraEqualityConstraints), a6);
        Vector a8 = VectorFactory.subVector(weights0, 2, a2);
        IterativeSolution a9 = (IterativeSolution)this.false.solve(a7);
        Vector a10 = a9.search(a8);
        Vector a11 = Corvalan2005.final(a10);
        return a11;
    }

    public Vector getDiversifiedWeights(WeightsConstraint constraint, Vector weights0, Matrix sigma, Vector r) throws Exception {
        return this.getDiversifiedWeights(constraint, weights0, sigma, r, null, null);
    }

    private static EqualityConstraints final(EqualityConstraints a2) {
        if (a2 == null) {
            return null;
        }
        GeneralEqualityConstraints a3 = new GeneralEqualityConstraints(Corvalan2005.final(a2.getConstraints()));
        return a3;
    }

    private static Vector final(Vector a2) {
        return new DenseVector(Corvalan2005.final(a2.toArray()));
    }

    public static interface WeightsConstraint {
        public LessThanConstraints constraints();
    }
}

