/*
 * Decompiled with CFR 0.152.
 */
package org.teneighty.heap;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.teneighty.heap.AbstractLinkedHeap;
import org.teneighty.heap.Heap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkewHeap<TKey, TValue>
extends AbstractLinkedHeap<TKey, TValue>
implements Heap<TKey, TValue>,
Serializable {
    private Comparator<? super TKey> comparator;
    private static final long serialVersionUID = 183483493L;
    private int size;
    private AbstractLinkedHeap.HeapReference back_reference;
    private SkewHeapEntry<TKey, TValue> root;
    private volatile long mod_count;

    public SkewHeap() {
        this(null);
    }

    @Override
    public Iterator<Heap.Entry<TKey, TValue>> iterator() {
        return new EntryIterator();
    }

    private void writeObject(ObjectOutputStream a2) throws IOException {
        SkewHeap a3;
        a2.writeObject(a3.comparator);
        a2.writeInt(a3.size);
        EntryIterator a4 = a3.new EntryIterator();
        Heap.Entry a5 = null;
        while (a4.hasNext()) {
            try {
                a5 = (Heap.Entry)a4.next();
                a2.writeObject(a5.getKey());
                a2.writeObject(a5.getValue());
            }
            catch (ConcurrentModificationException a6) {
                throw (IOException)new IOException("Heap structure changed during serialization").initCause(a6);
            }
        }
    }

    @Override
    public void decreaseKey(Heap.Entry<TKey, TValue> e2, TKey key) throws IllegalArgumentException, ClassCastException, NullPointerException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (this.compareKeys(key, e2.getKey()) > 0) {
            throw new IllegalArgumentException();
        }
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        SkewHeapEntry a2 = (SkewHeapEntry)e2;
        if (a2 == this.root) {
            a2.setKey(key);
            ++this.mod_count;
            return;
        }
        SkewHeapEntry a3 = a2.parent;
        a2.parent = null;
        SkewHeapEntry a4 = a2.left;
        SkewHeapEntry a5 = a2.right;
        a2.right = null;
        a2.left = null;
        if (a4 == null && a5 == null) {
            if (a3.left == a2) {
                a3.left = null;
            } else {
                a3.right = null;
            }
        } else {
            if (a4 != null) {
                a4.parent = null;
            }
            if (a5 != null) {
                a5.parent = null;
            }
            SkewHeapEntry a6 = this.link(a4, a5);
            a6.parent = a3;
            if (a3.left == a2) {
                a3.left = a6;
            } else {
                a3.right = a6;
            }
        }
        a2.setKey(key);
        this.root = this.link(this.root, a2);
        ++this.mod_count;
    }

    private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
        SkewHeap a3;
        a3.comparator = (Comparator)a2.readObject();
        int a4 = a2.readInt();
        a3.back_reference = new AbstractLinkedHeap.HeapReference(a3);
        for (int a5 = 0; a5 < a4; ++a5) {
            Object a6 = a2.readObject();
            Object a7 = a2.readObject();
            a3.insert(a6, a7);
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void clear() {
        this.root = null;
        this.back_reference.clearHeap();
        this.back_reference = new AbstractLinkedHeap.HeapReference(this);
        this.size = 0;
        ++this.mod_count;
    }

    public SkewHeap(Comparator<? super TKey> comparator) {
        this.comparator = comparator;
        this.size = 0;
        this.mod_count = 0L;
        this.root = null;
        this.back_reference = new AbstractLinkedHeap.HeapReference(this);
    }

    private SkewHeapEntry<TKey, TValue> link(SkewHeapEntry<TKey, TValue> a2, SkewHeapEntry<TKey, TValue> a3) {
        SkewHeapEntry<TKey, TValue> a4;
        SkewHeapEntry<TKey, TValue> a5;
        SkewHeap a6;
        if (a2 == null) {
            return a3;
        }
        if (a3 == null) {
            return a2;
        }
        if (a6.compare(a2, a3) < 0) {
            a5 = a2;
            a4 = a3;
        } else {
            a5 = a3;
            a4 = a2;
        }
        SkewHeapEntry a7 = a5.right;
        a5.right = a5.left;
        a7 = a6.link(a7, a4);
        a7.parent = a5;
        a5.left = a7;
        return a5;
    }

    @Override
    public boolean holdsEntry(Heap.Entry<TKey, TValue> e2) throws NullPointerException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!e2.getClass().equals(SkewHeapEntry.class)) {
            return false;
        }
        SkewHeapEntry a2 = (SkewHeapEntry)e2;
        return a2.isContainedBy(this);
    }

    @Override
    public Heap.Entry<TKey, TValue> getMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.root;
    }

    @Override
    public Comparator<? super TKey> getComparator() {
        return this.comparator;
    }

    @Override
    public Heap.Entry<TKey, TValue> extractMinimum() throws NoSuchElementException {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        SkewHeapEntry<TKey, TValue> a2 = this.root;
        this.root = this.link(this.root.left, this.root.right);
        if (this.root != null) {
            this.root.parent = null;
        }
        a2.left = null;
        a2.right = null;
        a2.clearSourceReference();
        --this.size;
        ++this.mod_count;
        return a2;
    }

    @Override
    public Heap.Entry<TKey, TValue> insert(TKey key, TValue value) throws ClassCastException, NullPointerException {
        SkewHeapEntry<TKey, TValue> a2 = new SkewHeapEntry<TKey, TValue>(key, value, this.back_reference);
        this.root = this.link(this.root, a2);
        ++this.size;
        ++this.mod_count;
        return a2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void union(Heap<TKey, TValue> other) throws ClassCastException, NullPointerException, IllegalArgumentException {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            throw new IllegalArgumentException();
        }
        SkewHeap a2 = (SkewHeap)other;
        if (other.isEmpty()) {
            return;
        }
        try {
            SkewHeapEntry<TKey, TValue> a3 = a2.root;
            this.root = this.link(this.root, a3);
            a2.back_reference.setHeap(this);
            a2.back_reference = new AbstractLinkedHeap.HeapReference(a2);
            this.size += a2.size;
            ++this.mod_count;
        }
        finally {
            a2.clear();
        }
    }

    @Override
    public void delete(Heap.Entry<TKey, TValue> e2) throws IllegalArgumentException, NullPointerException {
        if (e2 == null) {
            throw new NullPointerException();
        }
        if (!this.holdsEntry(e2)) {
            throw new IllegalArgumentException();
        }
        SkewHeapEntry a2 = (SkewHeapEntry)e2;
        if (a2 == this.root) {
            this.extractMinimum();
            return;
        }
        SkewHeapEntry a3 = a2.parent;
        SkewHeapEntry a4 = a2.left;
        SkewHeapEntry a5 = a2.right;
        if (a4 == null && a5 == null) {
            if (a3.left == a2) {
                a3.left = null;
            } else {
                a3.right = null;
            }
        } else {
            if (a4 != null) {
                a4.parent = null;
            }
            if (a5 != null) {
                a5.parent = null;
            }
            SkewHeapEntry a6 = this.link(a4, a5);
            a6.parent = a3;
            if (a3.left == a2) {
                a3.left = a6;
            } else {
                a3.right = a6;
            }
        }
        a2.clearSourceReference();
        a2.parent = null;
        a2.right = null;
        a2.left = null;
        --this.size;
        ++this.mod_count;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SkewHeapEntry<TKey, TValue>
    extends AbstractLinkedHeap.AbstractLinkedHeapEntry<TKey, TValue>
    implements Heap.Entry<TKey, TValue>,
    Serializable {
        transient SkewHeapEntry<TKey, TValue> right = null;
        private static final long serialVersionUID = 98359835983L;
        transient SkewHeapEntry<TKey, TValue> left = null;
        transient SkewHeapEntry<TKey, TValue> parent = null;

        SkewHeapEntry(TKey a2, TValue a3, AbstractLinkedHeap.HeapReference a4) {
            super(a2, a3, a4);
            SkewHeapEntry a5;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EntryIterator
    implements Iterator<Heap.Entry<TKey, TValue>> {
        private SkewHeapEntry<TKey, TValue> next;
        private final long my_mod_count;

        @Override
        public boolean hasNext() throws ConcurrentModificationException {
            this.checkForConcurrentModification();
            return this.next != null;
        }

        @Override
        public Heap.Entry<TKey, TValue> next() throws NoSuchElementException, ConcurrentModificationException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            SkewHeapEntry a2 = this.next;
            this.next = this.getSuccessor(this.next);
            return a2;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        private void checkForConcurrentModification() throws ConcurrentModificationException {
            EntryIterator a2;
            if (a2.my_mod_count != a2.SkewHeap.this.mod_count) {
                throw new ConcurrentModificationException();
            }
        }

        EntryIterator() {
            EntryIterator a2;
            a2.my_mod_count = a2.SkewHeap.this.mod_count;
            a2.next = a2.SkewHeap.this.root;
        }

        private SkewHeapEntry<TKey, TValue> getSuccessor(SkewHeapEntry<TKey, TValue> a2) {
            if (a2 == null) {
                return null;
            }
            if (a2.left != null) {
                return a2.left;
            }
            if (a2.right != null) {
                return a2.right;
            }
            SkewHeapEntry a3 = a2.parent;
            SkewHeapEntry a4 = a2;
            while (a3 != null) {
                if (a3.left == a4 && a3.right != null) {
                    return a3.right;
                }
                a4 = a3;
                a3 = a3.parent;
            }
            return null;
        }
    }
}

