/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadWritablePeriod;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.FormatUtils;
import org.joda.time.format.PeriodParser;
import org.joda.time.format.PeriodPrinter;

public class PeriodFormatter {
    private final Locale iLocale;
    private final PeriodPrinter iPrinter;
    private final PeriodType iParseType;
    private final PeriodParser iParser;

    public boolean isParser() {
        return this.iParser != null;
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public PeriodFormatter(PeriodPrinter arg0, PeriodParser arg1) {
        this.iPrinter = arg0;
        this.iParser = arg1;
        this.iLocale = null;
        this.iParseType = null;
    }

    public String print(ReadablePeriod arg0) {
        this.checkPrinter();
        this.checkPeriod(arg0);
        PeriodPrinter periodPrinter = this.getPrinter();
        StringBuffer stringBuffer = new StringBuffer(periodPrinter.calculatePrintedLength(arg0, this.iLocale));
        periodPrinter.printTo(stringBuffer, arg0, this.iLocale);
        return stringBuffer.toString();
    }

    public PeriodType getParseType() {
        return this.iParseType;
    }

    public void printTo(Writer arg0, ReadablePeriod arg1) throws IOException {
        this.checkPrinter();
        this.checkPeriod(arg1);
        this.getPrinter().printTo(arg0, arg1, this.iLocale);
    }

    public PeriodParser getParser() {
        return this.iParser;
    }

    public boolean isPrinter() {
        return this.iPrinter != null;
    }

    public int parseInto(ReadWritablePeriod arg0, String arg1, int arg2) {
        this.checkParser();
        this.checkPeriod(arg0);
        return this.getParser().parseInto(arg0, arg1, arg2, this.iLocale);
    }

    public void printTo(StringBuffer arg0, ReadablePeriod arg1) {
        this.checkPrinter();
        this.checkPeriod(arg1);
        this.getPrinter().printTo(arg0, arg1, this.iLocale);
    }

    private void checkParser() {
        PeriodFormatter a2;
        if (a2.iParser == null) {
            throw new UnsupportedOperationException("Parsing not supported");
        }
    }

    public MutablePeriod parseMutablePeriod(String arg0) {
        this.checkParser();
        MutablePeriod mutablePeriod = new MutablePeriod(0L, this.iParseType);
        int n = this.getParser().parseInto(mutablePeriod, arg0, 0, this.iLocale);
        if (n >= 0) {
            if (n >= arg0.length()) {
                return mutablePeriod;
            }
        } else {
            n ^= 0xFFFFFFFF;
        }
        throw new IllegalArgumentException(FormatUtils.createErrorMessage(arg0, n));
    }

    public Period parsePeriod(String arg0) {
        this.checkParser();
        return this.parseMutablePeriod(arg0).toPeriod();
    }

    public PeriodFormatter withParseType(PeriodType arg0) {
        if (arg0 == this.iParseType) {
            return this;
        }
        return new PeriodFormatter(this.iPrinter, this.iParser, this.iLocale, arg0);
    }

    PeriodFormatter(PeriodPrinter a2, PeriodParser a3, Locale a4, PeriodType a5) {
        PeriodFormatter a6;
        a6.iPrinter = a2;
        a6.iParser = a3;
        a6.iLocale = a4;
        a6.iParseType = a5;
    }

    private void checkPeriod(ReadablePeriod a2) {
        if (a2 == null) {
            throw new IllegalArgumentException("Period must not be null");
        }
    }

    public PeriodFormatter withLocale(Locale arg0) {
        if (arg0 == this.getLocale() || arg0 != null && arg0.equals(this.getLocale())) {
            return this;
        }
        return new PeriodFormatter(this.iPrinter, this.iParser, arg0, this.iParseType);
    }

    public PeriodPrinter getPrinter() {
        return this.iPrinter;
    }

    private void checkPrinter() {
        PeriodFormatter a2;
        if (a2.iPrinter == null) {
            throw new UnsupportedOperationException("Printing not supported");
        }
    }
}

