/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.InternalParser;
import org.joda.time.format.InternalPrinter;

public class DateTimeFormat {
    private static final int PATTERN_CACHE_SIZE = 500;
    static final int TIME = 1;
    static final int DATETIME = 2;
    static final int LONG = 1;
    static final int DATE = 0;
    private static final ConcurrentHashMap<String, DateTimeFormatter> cPatternCache = new ConcurrentHashMap();
    private static final AtomicReferenceArray<DateTimeFormatter> cStyleCache = new AtomicReferenceArray(25);
    static final int SHORT = 3;
    static final int MEDIUM = 2;
    static final int FULL = 0;
    static final int NONE = 4;

    public static DateTimeFormatter forPattern(String arg0) {
        return DateTimeFormat.createFormatterForPattern(arg0);
    }

    static void appendPatternTo(DateTimeFormatterBuilder a2, String a3) {
        DateTimeFormat.parsePatternTo(a2, a3);
    }

    private static boolean isNumericToken(String a2) {
        int n = a2.length();
        if (n > 0) {
            char c2 = a2.charAt(0);
            switch (c2) {
                case 'C': 
                case 'D': 
                case 'F': 
                case 'H': 
                case 'K': 
                case 'S': 
                case 'W': 
                case 'Y': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'h': 
                case 'k': 
                case 'm': 
                case 's': 
                case 'w': 
                case 'x': 
                case 'y': {
                    return true;
                }
                case 'M': {
                    if (n > 2) break;
                    return true;
                }
            }
        }
        return false;
    }

    protected DateTimeFormat() {
    }

    public static DateTimeFormatter longDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 1);
    }

    public static DateTimeFormatter mediumDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 2);
    }

    public static DateTimeFormatter longDate() {
        return DateTimeFormat.createFormatterForStyleIndex(1, 4);
    }

    public static DateTimeFormatter shortDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 3);
    }

    private static void parsePatternTo(DateTimeFormatterBuilder a2, String a3) {
        int n = a3.length();
        int[] nArray = new int[1];
        block30: for (int i2 = 0; i2 < n; ++i2) {
            nArray[0] = i2;
            String string = DateTimeFormat.parseToken(a3, nArray);
            i2 = nArray[0];
            int n2 = string.length();
            if (n2 == 0) break;
            char c2 = string.charAt(0);
            switch (c2) {
                case 'G': {
                    a2.appendEraText();
                    continue block30;
                }
                case 'C': {
                    a2.appendCenturyOfEra(n2, n2);
                    continue block30;
                }
                case 'Y': 
                case 'x': 
                case 'y': {
                    if (n2 == 2) {
                        boolean bl = true;
                        if (i2 + 1 < n) {
                            nArray[0] = nArray[0] + 1;
                            if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(a3, nArray))) {
                                bl = false;
                            }
                            nArray[0] = nArray[0] - 1;
                        }
                        switch (c2) {
                            case 'x': {
                                a2.appendTwoDigitWeekyear(new DateTime().getWeekyear() - 30, bl);
                                continue block30;
                            }
                        }
                        a2.appendTwoDigitYear(new DateTime().getYear() - 30, bl);
                        continue block30;
                    }
                    int n3 = 9;
                    if (i2 + 1 < n) {
                        nArray[0] = nArray[0] + 1;
                        if (DateTimeFormat.isNumericToken(DateTimeFormat.parseToken(a3, nArray))) {
                            n3 = n2;
                        }
                        nArray[0] = nArray[0] - 1;
                    }
                    switch (c2) {
                        case 'x': {
                            a2.appendWeekyear(n2, n3);
                            break;
                        }
                        case 'y': {
                            a2.appendYear(n2, n3);
                            break;
                        }
                        case 'Y': {
                            a2.appendYearOfEra(n2, n3);
                        }
                    }
                    continue block30;
                }
                case 'M': {
                    if (n2 >= 3) {
                        if (n2 >= 4) {
                            a2.appendMonthOfYearText();
                            continue block30;
                        }
                        a2.appendMonthOfYearShortText();
                        continue block30;
                    }
                    a2.appendMonthOfYear(n2);
                    continue block30;
                }
                case 'd': {
                    a2.appendDayOfMonth(n2);
                    continue block30;
                }
                case 'a': {
                    a2.appendHalfdayOfDayText();
                    continue block30;
                }
                case 'h': {
                    a2.appendClockhourOfHalfday(n2);
                    continue block30;
                }
                case 'H': {
                    a2.appendHourOfDay(n2);
                    continue block30;
                }
                case 'k': {
                    a2.appendClockhourOfDay(n2);
                    continue block30;
                }
                case 'K': {
                    a2.appendHourOfHalfday(n2);
                    continue block30;
                }
                case 'm': {
                    a2.appendMinuteOfHour(n2);
                    continue block30;
                }
                case 's': {
                    a2.appendSecondOfMinute(n2);
                    continue block30;
                }
                case 'S': {
                    a2.appendFractionOfSecond(n2, n2);
                    continue block30;
                }
                case 'e': {
                    a2.appendDayOfWeek(n2);
                    continue block30;
                }
                case 'E': {
                    if (n2 >= 4) {
                        a2.appendDayOfWeekText();
                        continue block30;
                    }
                    a2.appendDayOfWeekShortText();
                    continue block30;
                }
                case 'D': {
                    a2.appendDayOfYear(n2);
                    continue block30;
                }
                case 'w': {
                    a2.appendWeekOfWeekyear(n2);
                    continue block30;
                }
                case 'z': {
                    if (n2 >= 4) {
                        a2.appendTimeZoneName();
                        continue block30;
                    }
                    a2.appendTimeZoneShortName(null);
                    continue block30;
                }
                case 'Z': {
                    if (n2 == 1) {
                        a2.appendTimeZoneOffset(null, "Z", false, 2, 2);
                        continue block30;
                    }
                    if (n2 == 2) {
                        a2.appendTimeZoneOffset(null, "Z", true, 2, 2);
                        continue block30;
                    }
                    a2.appendTimeZoneId();
                    continue block30;
                }
                case '\'': {
                    String string2 = string.substring(1);
                    if (string2.length() == 1) {
                        a2.appendLiteral(string2.charAt(0));
                        continue block30;
                    }
                    a2.appendLiteral(new String(string2));
                    continue block30;
                }
                default: {
                    throw new IllegalArgumentException("Illegal pattern component: " + string);
                }
            }
        }
    }

    private static DateTimeFormatter createFormatterForStyle(String a2) {
        if (a2 == null || a2.length() != 2) {
            throw new IllegalArgumentException("Invalid style specification: " + a2);
        }
        int n = DateTimeFormat.selectStyle(a2.charAt(0));
        int n2 = DateTimeFormat.selectStyle(a2.charAt(1));
        if (n == 4 && n2 == 4) {
            throw new IllegalArgumentException("Style '--' is invalid");
        }
        return DateTimeFormat.createFormatterForStyleIndex(n, n2);
    }

    public static DateTimeFormatter fullTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 0);
    }

    private static DateTimeFormatter createDateTimeFormatter(int a2, int a3) {
        int n = 2;
        if (a2 == 4) {
            n = 1;
        } else if (a3 == 4) {
            n = 0;
        }
        StyleFormatter styleFormatter = new StyleFormatter(a2, a3, n);
        return new DateTimeFormatter(styleFormatter, styleFormatter);
    }

    public static DateTimeFormatter longTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 1);
    }

    public static DateTimeFormatter forStyle(String arg0) {
        return DateTimeFormat.createFormatterForStyle(arg0);
    }

    public static DateTimeFormatter shortTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 3);
    }

    private static String parseToken(String a2, int[] a3) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = a2.length();
        char c2 = a2.charAt(n);
        if (c2 >= 'A' && c2 <= 'Z' || c2 >= 'a' && c2 <= 'z') {
            char c3;
            stringBuilder.append(c2);
            while (n + 1 < n2 && (c3 = a2.charAt(n + 1)) == c2) {
                stringBuilder.append(c2);
                ++n;
            }
        } else {
            stringBuilder.append('\'');
            boolean bl = false;
            for (n = a3[0]; n < n2; ++n) {
                c2 = a2.charAt(n);
                if (c2 == '\'') {
                    if (n + 1 < n2 && a2.charAt(n + 1) == '\'') {
                        ++n;
                        stringBuilder.append(c2);
                        continue;
                    }
                    bl = !bl;
                    continue;
                }
                if (bl || (c2 < 'A' || c2 > 'Z') && (c2 < 'a' || c2 > 'z')) {
                    stringBuilder.append(c2);
                    continue;
                }
                break;
            }
        }
        a3[0] = --n;
        return stringBuilder.toString();
    }

    public static String patternForStyle(String arg0, Locale arg1) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormat.createFormatterForStyle(arg0);
        if (arg1 == null) {
            arg1 = Locale.getDefault();
        }
        return ((StyleFormatter)dateTimeFormatter.getPrinter0()).getPattern(arg1);
    }

    private static DateTimeFormatter createFormatterForPattern(String a2) {
        if (a2 == null || a2.length() == 0) {
            throw new IllegalArgumentException("Invalid pattern specification");
        }
        DateTimeFormatter dateTimeFormatter = cPatternCache.get(a2);
        if (dateTimeFormatter == null) {
            DateTimeFormatter dateTimeFormatter2;
            DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
            DateTimeFormat.parsePatternTo(dateTimeFormatterBuilder, a2);
            dateTimeFormatter = dateTimeFormatterBuilder.toFormatter();
            if (cPatternCache.size() < 500 && (dateTimeFormatter2 = cPatternCache.putIfAbsent(a2, dateTimeFormatter)) != null) {
                dateTimeFormatter = dateTimeFormatter2;
            }
        }
        return dateTimeFormatter;
    }

    private static DateTimeFormatter createFormatterForStyleIndex(int a2, int a3) {
        int n = (a2 << 2) + a2 + a3;
        if (n >= cStyleCache.length()) {
            return DateTimeFormat.createDateTimeFormatter(a2, a3);
        }
        DateTimeFormatter dateTimeFormatter = cStyleCache.get(n);
        if (dateTimeFormatter == null && !cStyleCache.compareAndSet(n, null, dateTimeFormatter = DateTimeFormat.createDateTimeFormatter(a2, a3))) {
            dateTimeFormatter = cStyleCache.get(n);
        }
        return dateTimeFormatter;
    }

    private static int selectStyle(char a2) {
        switch (a2) {
            case 'S': {
                return 3;
            }
            case 'M': {
                return 2;
            }
            case 'L': {
                return 1;
            }
            case 'F': {
                return 0;
            }
            case '-': {
                return 4;
            }
        }
        throw new IllegalArgumentException("Invalid style character: " + a2);
    }

    public static DateTimeFormatter fullDate() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 4);
    }

    public static DateTimeFormatter fullDateTime() {
        return DateTimeFormat.createFormatterForStyleIndex(0, 0);
    }

    public static DateTimeFormatter mediumDate() {
        return DateTimeFormat.createFormatterForStyleIndex(2, 4);
    }

    public static DateTimeFormatter mediumTime() {
        return DateTimeFormat.createFormatterForStyleIndex(4, 2);
    }

    public static DateTimeFormatter shortDate() {
        return DateTimeFormat.createFormatterForStyleIndex(3, 4);
    }

    static class StyleFormatterCacheKey {
        private final int combinedTypeAndStyle;
        private final Locale locale;

        public StyleFormatterCacheKey(int arg0, int arg1, int arg2, Locale arg3) {
            this.locale = arg3;
            this.combinedTypeAndStyle = arg0 + (arg1 << 4) + (arg2 << 8);
        }

        public int hashCode() {
            int n = 1;
            n = 31 * n + this.combinedTypeAndStyle;
            n = 31 * n + (this.locale == null ? 0 : this.locale.hashCode());
            return n;
        }

        public boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (!(arg0 instanceof StyleFormatterCacheKey)) {
                return false;
            }
            StyleFormatterCacheKey styleFormatterCacheKey = (StyleFormatterCacheKey)arg0;
            if (this.combinedTypeAndStyle != styleFormatterCacheKey.combinedTypeAndStyle) {
                return false;
            }
            return !(this.locale == null ? styleFormatterCacheKey.locale != null : !this.locale.equals(styleFormatterCacheKey.locale));
        }
    }

    static class StyleFormatter
    implements InternalPrinter,
    InternalParser {
        private final int iTimeStyle;
        private static final ConcurrentHashMap<StyleFormatterCacheKey, DateTimeFormatter> cCache = new ConcurrentHashMap();
        private final int iType;
        private final int iDateStyle;

        public int parseInto(DateTimeParserBucket arg0, CharSequence arg1, int arg2) {
            InternalParser internalParser = this.getFormatter(arg0.getLocale()).getParser0();
            return internalParser.parseInto(arg0, arg1, arg2);
        }

        public int estimatePrintedLength() {
            return 40;
        }

        public void printTo(Appendable arg0, ReadablePartial arg1, Locale arg2) throws IOException {
            InternalPrinter internalPrinter = this.getFormatter(arg2).getPrinter0();
            internalPrinter.printTo(arg0, arg1, arg2);
        }

        StyleFormatter(int a2, int a3, int a4) {
            StyleFormatter a5;
            a5.iDateStyle = a2;
            a5.iTimeStyle = a3;
            a5.iType = a4;
        }

        String getPattern(Locale a2) {
            StyleFormatter a3;
            DateFormat dateFormat = null;
            switch (a3.iType) {
                case 0: {
                    dateFormat = DateFormat.getDateInstance(a3.iDateStyle, a2);
                    break;
                }
                case 1: {
                    dateFormat = DateFormat.getTimeInstance(a3.iTimeStyle, a2);
                    break;
                }
                case 2: {
                    dateFormat = DateFormat.getDateTimeInstance(a3.iDateStyle, a3.iTimeStyle, a2);
                }
            }
            if (!(dateFormat instanceof SimpleDateFormat)) {
                throw new IllegalArgumentException("No datetime pattern for locale: " + a2);
            }
            return ((SimpleDateFormat)dateFormat).toPattern();
        }

        public int estimateParsedLength() {
            return 40;
        }

        public void printTo(Appendable arg0, long arg1, Chronology arg2, int arg3, DateTimeZone arg4, Locale arg5) throws IOException {
            InternalPrinter internalPrinter = this.getFormatter(arg5).getPrinter0();
            internalPrinter.printTo(arg0, arg1, arg2, arg3, arg4, arg5);
        }

        private DateTimeFormatter getFormatter(Locale a2) {
            DateTimeFormatter dateTimeFormatter;
            StyleFormatter a3;
            a2 = a2 == null ? Locale.getDefault() : a2;
            StyleFormatterCacheKey styleFormatterCacheKey = new StyleFormatterCacheKey(a3.iType, a3.iDateStyle, a3.iTimeStyle, a2);
            DateTimeFormatter dateTimeFormatter2 = cCache.get(styleFormatterCacheKey);
            if (dateTimeFormatter2 == null && (dateTimeFormatter = cCache.putIfAbsent(styleFormatterCacheKey, dateTimeFormatter2 = DateTimeFormat.forPattern(a3.getPattern(a2)))) != null) {
                dateTimeFormatter2 = dateTimeFormatter;
            }
            return dateTimeFormatter2;
        }
    }
}

