/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import java.io.Serializable;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeUtils;
import org.joda.time.ReadablePartial;
import org.joda.time.base.AbstractPartial;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public abstract class BasePartial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 2353678632973660L;
    private final Chronology iChronology;
    private final int[] iValues;

    public String toString(String arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).print(this);
    }

    public String toString(String arg0, Locale arg1) throws IllegalArgumentException {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).withLocale(arg1).print(this);
    }

    public int getValue(int arg0) {
        return this.iValues[arg0];
    }

    protected BasePartial() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)null);
    }

    protected void setValues(int[] arg0) {
        this.getChronology().validate(this, arg0);
        System.arraycopy(arg0, 0, this.iValues, 0, this.iValues.length);
    }

    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    protected BasePartial(long arg0) {
        this(arg0, (Chronology)null);
    }

    protected BasePartial(int[] arg0, Chronology arg1) {
        arg1 = DateTimeUtils.getChronology(arg1);
        this.iChronology = arg1.withUTC();
        arg1.validate(this, arg0);
        this.iValues = arg0;
    }

    protected BasePartial(Object arg0, Chronology arg1) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(arg0);
        arg1 = partialConverter.getChronology(arg0, arg1);
        arg1 = DateTimeUtils.getChronology(arg1);
        this.iChronology = arg1.withUTC();
        this.iValues = partialConverter.getPartialValues(this, arg0, arg1);
    }

    protected BasePartial(long arg0, Chronology arg1) {
        arg1 = DateTimeUtils.getChronology(arg1);
        this.iChronology = arg1.withUTC();
        this.iValues = arg1.get(this, arg0);
    }

    protected BasePartial(Object arg0, Chronology arg1, DateTimeFormatter arg2) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(arg0);
        arg1 = partialConverter.getChronology(arg0, arg1);
        arg1 = DateTimeUtils.getChronology(arg1);
        this.iChronology = arg1.withUTC();
        this.iValues = partialConverter.getPartialValues(this, arg0, arg1, arg2);
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    protected BasePartial(Chronology arg0) {
        this(DateTimeUtils.currentTimeMillis(), arg0);
    }

    protected BasePartial(BasePartial arg0, Chronology arg1) {
        this.iChronology = arg1.withUTC();
        this.iValues = arg0.iValues;
    }

    protected void setValue(int arg0, int arg1) {
        DateTimeField dateTimeField = this.getField(arg0);
        int[] nArray = dateTimeField.set(this, arg0, this.iValues, arg1);
        System.arraycopy(nArray, 0, this.iValues, 0, this.iValues.length);
    }

    protected BasePartial(BasePartial arg0, int[] arg1) {
        this.iChronology = arg0.iChronology;
        this.iValues = arg1;
    }
}

