/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.convert.ToString;
import org.joda.time.DurationFieldType;
import org.joda.time.MutablePeriod;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public abstract class AbstractPeriod
implements ReadablePeriod {
    public int[] getValues() {
        int[] nArray = new int[this.size()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.getValue(i2);
        }
        return nArray;
    }

    public int hashCode() {
        int n = 17;
        int n2 = this.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            n = 27 * n + this.getValue(i2);
            n = 27 * n + this.getFieldType(i2).hashCode();
        }
        return n;
    }

    public Period toPeriod() {
        return new Period(this);
    }

    public String toString(PeriodFormatter arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return arg0.print(this);
    }

    public int get(DurationFieldType arg0) {
        int n = this.indexOf(arg0);
        if (n == -1) {
            return 0;
        }
        return this.getValue(n);
    }

    protected AbstractPeriod() {
    }

    public DurationFieldType getFieldType(int arg0) {
        return this.getPeriodType().getFieldType(arg0);
    }

    @ToString
    public String toString() {
        return ISOPeriodFormat.standard().print(this);
    }

    public DurationFieldType[] getFieldTypes() {
        DurationFieldType[] durationFieldTypeArray = new DurationFieldType[this.size()];
        for (int i2 = 0; i2 < durationFieldTypeArray.length; ++i2) {
            durationFieldTypeArray[i2] = this.getFieldType(i2);
        }
        return durationFieldTypeArray;
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof ReadablePeriod)) {
            return false;
        }
        ReadablePeriod readablePeriod = (ReadablePeriod)arg0;
        if (this.size() != readablePeriod.size()) {
            return false;
        }
        int n = this.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (this.getValue(i2) == readablePeriod.getValue(i2) && this.getFieldType(i2) == readablePeriod.getFieldType(i2)) continue;
            return false;
        }
        return true;
    }

    public MutablePeriod toMutablePeriod() {
        return new MutablePeriod(this);
    }

    public int size() {
        return this.getPeriodType().size();
    }

    public boolean isSupported(DurationFieldType arg0) {
        return this.getPeriodType().isSupported(arg0);
    }

    public int indexOf(DurationFieldType arg0) {
        return this.getPeriodType().indexOf(arg0);
    }
}

