/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.base;

import org.joda.convert.ToString;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.format.FormatUtils;

public abstract class AbstractDuration
implements ReadableDuration {
    public Duration toDuration() {
        return new Duration(this.getMillis());
    }

    public Period toPeriod() {
        return new Period(this.getMillis());
    }

    public int compareTo(ReadableDuration arg0) {
        long l2;
        long l3 = this.getMillis();
        if (l3 < (l2 = arg0.getMillis())) {
            return -1;
        }
        if (l3 > l2) {
            return 1;
        }
        return 0;
    }

    protected AbstractDuration() {
    }

    public boolean isLongerThan(ReadableDuration arg0) {
        if (arg0 == null) {
            arg0 = Duration.ZERO;
        }
        return this.compareTo(arg0) > 0;
    }

    public boolean isShorterThan(ReadableDuration arg0) {
        if (arg0 == null) {
            arg0 = Duration.ZERO;
        }
        return this.compareTo(arg0) < 0;
    }

    @ToString
    public String toString() {
        long l2 = this.getMillis();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PT");
        boolean bl = l2 < 0L;
        FormatUtils.appendUnpaddedInteger(stringBuffer, l2);
        while (stringBuffer.length() < (bl ? 7 : 6)) {
            stringBuffer.insert(bl ? 3 : 2, "0");
        }
        if (l2 / 1000L * 1000L == l2) {
            stringBuffer.setLength(stringBuffer.length() - 3);
        } else {
            stringBuffer.insert(stringBuffer.length() - 3, ".");
        }
        stringBuffer.append('S');
        return stringBuffer.toString();
    }

    public boolean isEqual(ReadableDuration arg0) {
        if (arg0 == null) {
            arg0 = Duration.ZERO;
        }
        return this.compareTo(arg0) == 0;
    }

    public int hashCode() {
        long l2 = this.getMillis();
        return (int)(l2 ^ l2 >>> 32);
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (!(arg0 instanceof ReadableDuration)) {
            return false;
        }
        ReadableDuration readableDuration = (ReadableDuration)arg0;
        return this.getMillis() == readableDuration.getMillis();
    }
}

