/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.DurationFieldType;
import org.joda.time.LocalDate;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadableInterval;
import org.joda.time.ReadablePartial;
import org.joda.time.base.BaseSingleFieldPeriod;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.ISOPeriodFormat;
import org.joda.time.format.PeriodFormatter;

public final class Years
extends BaseSingleFieldPeriod {
    public static final Years MAX_VALUE;
    public static final Years ZERO;
    public static final Years MIN_VALUE;
    public static final Years TWO;
    private static final long serialVersionUID = 87525275727380868L;
    public static final Years ONE;
    private static final PeriodFormatter PARSER;
    public static final Years THREE;

    @ToString
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "Y";
    }

    public boolean isLessThan(Years arg0) {
        if (arg0 == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < arg0.getValue();
    }

    private Object readResolve() {
        Years a2;
        return Years.years(a2.getValue());
    }

    public PeriodType getPeriodType() {
        return PeriodType.years();
    }

    public int getYears() {
        return this.getValue();
    }

    public static Years yearsBetween(ReadableInstant arg0, ReadableInstant arg1) {
        int n = BaseSingleFieldPeriod.between(arg0, arg1, DurationFieldType.years());
        return Years.years(n);
    }

    public static Years yearsBetween(ReadablePartial arg0, ReadablePartial arg1) {
        if (arg0 instanceof LocalDate && arg1 instanceof LocalDate) {
            Chronology chronology = DateTimeUtils.getChronology(arg0.getChronology());
            int n = chronology.years().getDifference(((LocalDate)arg1).getLocalMillis(), ((LocalDate)arg0).getLocalMillis());
            return Years.years(n);
        }
        int n = BaseSingleFieldPeriod.between(arg0, arg1, ZERO);
        return Years.years(n);
    }

    public DurationFieldType getFieldType() {
        return DurationFieldType.years();
    }

    static {
        ZERO = new Years(0);
        ONE = new Years(1);
        TWO = new Years(2);
        THREE = new Years(3);
        MAX_VALUE = new Years(Integer.MAX_VALUE);
        MIN_VALUE = new Years(Integer.MIN_VALUE);
        PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.years());
    }

    public Years dividedBy(int arg0) {
        if (arg0 == 1) {
            return this;
        }
        return Years.years(this.getValue() / arg0);
    }

    public Years plus(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        return Years.years(FieldUtils.safeAdd(this.getValue(), arg0));
    }

    @FromString
    public static Years parseYears(String arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        Period period = PARSER.parsePeriod(arg0);
        return Years.years(period.getYears());
    }

    private Years(int a2) {
        super(a2);
        Years a3;
    }

    public Years minus(Years arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.minus(arg0.getValue());
    }

    public Years negated() {
        return Years.years(FieldUtils.safeNegate(this.getValue()));
    }

    public static Years yearsIn(ReadableInterval arg0) {
        if (arg0 == null) {
            return ZERO;
        }
        int n = BaseSingleFieldPeriod.between(arg0.getStart(), arg0.getEnd(), DurationFieldType.years());
        return Years.years(n);
    }

    public Years minus(int arg0) {
        return this.plus(FieldUtils.safeNegate(arg0));
    }

    public boolean isGreaterThan(Years arg0) {
        if (arg0 == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > arg0.getValue();
    }

    public Years plus(Years arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.plus(arg0.getValue());
    }

    public static Years years(int arg0) {
        switch (arg0) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Years(arg0);
    }

    public Years multipliedBy(int arg0) {
        return Years.years(FieldUtils.safeMultiply(this.getValue(), arg0));
    }
}

