/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.Interval;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.ReadablePeriod;
import org.joda.time.base.BaseLocal;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.convert.ConverterManager;
import org.joda.time.convert.PartialConverter;
import org.joda.time.field.AbstractReadableInstantFieldProperty;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public final class LocalDate
extends BaseLocal
implements ReadablePartial,
Serializable {
    private static final Set<DurationFieldType> DATE_DURATION_TYPES = new HashSet<DurationFieldType>();
    private static final long serialVersionUID = -8775358157899L;
    private final Chronology iChronology;
    private transient int iHash;
    private static final int YEAR = 0;
    private static final int MONTH_OF_YEAR = 1;
    private final long iLocalMillis;
    private static final int DAY_OF_MONTH = 2;

    public LocalDate plusDays(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    @Deprecated
    public DateMidnight toDateMidnight() {
        return this.toDateMidnight(null);
    }

    public boolean isSupported(DurationFieldType arg0) {
        if (arg0 == null) {
            return false;
        }
        DurationField durationField = arg0.getField(this.getChronology());
        if (DATE_DURATION_TYPES.contains(arg0) || durationField.getUnitMillis() >= this.getChronology().days().getUnitMillis()) {
            return durationField.isSupported();
        }
        return false;
    }

    public LocalDate plusYears(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public int getDayOfMonth() {
        return this.getChronology().dayOfMonth().get(this.getLocalMillis());
    }

    public String toString(String arg0, Locale arg1) throws IllegalArgumentException {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).withLocale(arg1).print(this);
    }

    public LocalDate(Chronology arg0) {
        this(DateTimeUtils.currentTimeMillis(), arg0);
    }

    public DateTime toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public LocalDate withWeekOfWeekyear(int arg0) {
        return this.withLocalMillis(this.getChronology().weekOfWeekyear().set(this.getLocalMillis(), arg0));
    }

    public DateTime toDateTime(LocalTime arg0, DateTimeZone arg1) {
        if (arg0 == null) {
            return this.toDateTimeAtCurrentTime(arg1);
        }
        if (this.getChronology() != arg0.getChronology()) {
            throw new IllegalArgumentException("The chronology of the time does not match");
        }
        Chronology chronology = this.getChronology().withZone(arg1);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), arg0.getHourOfDay(), arg0.getMinuteOfHour(), arg0.getSecondOfMinute(), arg0.getMillisOfSecond(), chronology);
    }

    @Deprecated
    public DateMidnight toDateMidnight(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        Chronology chronology = this.getChronology().withZone(arg0);
        return new DateMidnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), chronology);
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public LocalDate withYear(int arg0) {
        return this.withLocalMillis(this.getChronology().year().set(this.getLocalMillis(), arg0));
    }

    public LocalDate(Object arg0, Chronology arg1) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(arg0);
        arg1 = partialConverter.getChronology(arg0, arg1);
        arg1 = DateTimeUtils.getChronology(arg1);
        this.iChronology = arg1.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, arg0, arg1, ISODateTimeFormat.localDateParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], 0);
    }

    @Deprecated
    public DateTime toDateTimeAtMidnight(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        Chronology chronology = this.getChronology().withZone(arg0);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), 0, 0, 0, 0, chronology);
    }

    public LocalDate(long arg0, DateTimeZone arg1) {
        this(arg0, (Chronology)ISOChronology.getInstance(arg1));
    }

    public LocalDate withMonthOfYear(int arg0) {
        return this.withLocalMillis(this.getChronology().monthOfYear().set(this.getLocalMillis(), arg0));
    }

    public LocalDate minus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, -1);
    }

    public int getDayOfWeek() {
        return this.getChronology().dayOfWeek().get(this.getLocalMillis());
    }

    public int size() {
        return 3;
    }

    public LocalDate(long arg0, Chronology arg1) {
        arg1 = DateTimeUtils.getChronology(arg1);
        long l2 = arg1.getZone().getMillisKeepLocal(DateTimeZone.UTC, arg0);
        arg1 = arg1.withUTC();
        this.iLocalMillis = arg1.dayOfMonth().roundFloor(l2);
        this.iChronology = arg1;
    }

    public static LocalDate now(DateTimeZone arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new LocalDate(arg0);
    }

    public LocalDate plusWeeks(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public LocalDate withDayOfWeek(int arg0) {
        return this.withLocalMillis(this.getChronology().dayOfWeek().set(this.getLocalMillis(), arg0));
    }

    public int getDayOfYear() {
        return this.getChronology().dayOfYear().get(this.getLocalMillis());
    }

    public int get(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(arg0)) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        return arg0.getField(this.getChronology()).get(this.getLocalMillis());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public LocalDate withYearOfCentury(int arg0) {
        return this.withLocalMillis(this.getChronology().yearOfCentury().set(this.getLocalMillis(), arg0));
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public LocalDate(DateTimeZone arg0) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(arg0));
    }

    public int compareTo(ReadablePartial arg0) {
        if (this == arg0) {
            return 0;
        }
        if (arg0 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)arg0;
            if (this.iChronology.equals(localDate.iChronology)) {
                return this.iLocalMillis < localDate.iLocalMillis ? -1 : (this.iLocalMillis == localDate.iLocalMillis ? 0 : 1);
            }
        }
        return super.compareTo(arg0);
    }

    public static LocalDate now(Chronology arg0) {
        if (arg0 == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new LocalDate(arg0);
    }

    public int getYear() {
        return this.getChronology().year().get(this.getLocalMillis());
    }

    public static LocalDate fromDateFields(Date arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (arg0.getTime() < 0L) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(arg0);
            return LocalDate.fromCalendarFields(gregorianCalendar);
        }
        return new LocalDate(arg0.getYear() + 1900, arg0.getMonth() + 1, arg0.getDate());
    }

    public DateTime toDateTimeAtStartOfDay(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        Chronology chronology = this.getChronology().withZone(arg0);
        long l2 = this.getLocalMillis() + 21600000L;
        long l3 = arg0.convertLocalToUTC(l2, false);
        l3 = chronology.dayOfMonth().roundFloor(l3);
        return new DateTime(l3, chronology);
    }

    public LocalDate minusYears(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().years().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public Interval toInterval(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        DateTime dateTime = this.toDateTimeAtStartOfDay(arg0);
        DateTime dateTime2 = this.plusDays(1).toDateTimeAtStartOfDay(arg0);
        return new Interval((ReadableInstant)dateTime, (ReadableInstant)dateTime2);
    }

    public String toString(String arg0) {
        if (arg0 == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(arg0).print(this);
    }

    public Date toDate() {
        Date date;
        int n = this.getDayOfMonth();
        Date date2 = new Date(this.getYear() - 1900, this.getMonthOfYear() - 1, n);
        LocalDate localDate = LocalDate.fromDateFields(date2);
        if (localDate.isBefore(this)) {
            while (!localDate.equals(this)) {
                date2.setTime(date2.getTime() + 3600000L);
                localDate = LocalDate.fromDateFields(date2);
            }
            while (date2.getDate() == n) {
                date2.setTime(date2.getTime() - 1000L);
            }
            date2.setTime(date2.getTime() + 1000L);
        } else if (localDate.equals(this) && (date = new Date(date2.getTime() - (long)TimeZone.getDefault().getDSTSavings())).getDate() == n) {
            date2 = date;
        }
        return date2;
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public DateTime toDateTimeAtCurrentTime(DateTimeZone arg0) {
        arg0 = DateTimeUtils.getZone(arg0);
        Chronology chronology = this.getChronology().withZone(arg0);
        long l2 = DateTimeUtils.currentTimeMillis();
        long l3 = chronology.set(this, l2);
        return new DateTime(l3, chronology);
    }

    @FromString
    public static LocalDate parse(String arg0) {
        return LocalDate.parse(arg0, ISODateTimeFormat.localDateParser());
    }

    protected DateTimeField getField(int arg0, Chronology arg1) {
        switch (arg0) {
            case 0: {
                return arg1.year();
            }
            case 1: {
                return arg1.monthOfYear();
            }
            case 2: {
                return arg1.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    public LocalDate(int arg0, int arg1, int arg2) {
        this(arg0, arg1, arg2, ISOChronology.getInstanceUTC());
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public LocalDate withYearOfEra(int arg0) {
        return this.withLocalMillis(this.getChronology().yearOfEra().set(this.getLocalMillis(), arg0));
    }

    static {
        DATE_DURATION_TYPES.add(DurationFieldType.days());
        DATE_DURATION_TYPES.add(DurationFieldType.weeks());
        DATE_DURATION_TYPES.add(DurationFieldType.months());
        DATE_DURATION_TYPES.add(DurationFieldType.weekyears());
        DATE_DURATION_TYPES.add(DurationFieldType.years());
        DATE_DURATION_TYPES.add(DurationFieldType.centuries());
        DATE_DURATION_TYPES.add(DurationFieldType.eras());
    }

    public LocalDate(int arg0, int arg1, int arg2, Chronology arg3) {
        arg3 = DateTimeUtils.getChronology(arg3).withUTC();
        long l2 = arg3.getDateTimeMillis(arg0, arg1, arg2, 0);
        this.iChronology = arg3;
        this.iLocalMillis = l2;
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public LocalDate withWeekyear(int arg0) {
        return this.withLocalMillis(this.getChronology().weekyear().set(this.getLocalMillis(), arg0));
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public int getWeekyear() {
        return this.getChronology().weekyear().get(this.getLocalMillis());
    }

    public LocalDate minusWeeks(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().weeks().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public DateTime toDateTime(LocalTime arg0) {
        return this.toDateTime(arg0, null);
    }

    public LocalDate withFields(ReadablePartial arg0) {
        if (arg0 == null) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().set(arg0, this.getLocalMillis()));
    }

    LocalDate withLocalMillis(long a2) {
        LocalDate a3;
        a2 = a3.iChronology.dayOfMonth().roundFloor(a2);
        return a2 == a3.getLocalMillis() ? a3 : new LocalDate(a2, a3.getChronology());
    }

    public int getWeekOfWeekyear() {
        return this.getChronology().weekOfWeekyear().get(this.getLocalMillis());
    }

    public LocalDate(Object arg0, DateTimeZone arg1) {
        PartialConverter partialConverter = ConverterManager.getInstance().getPartialConverter(arg0);
        Chronology chronology = partialConverter.getChronology(arg0, arg1);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] nArray = partialConverter.getPartialValues(this, arg0, chronology, ISODateTimeFormat.localDateParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(nArray[0], nArray[1], nArray[2], 0);
    }

    public LocalDate(Object arg0) {
        this(arg0, (Chronology)null);
    }

    public LocalDate plus(ReadablePeriod arg0) {
        return this.withPeriodAdded(arg0, 1);
    }

    public LocalDate minusMonths(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public boolean isSupported(DateTimeFieldType arg0) {
        if (arg0 == null) {
            return false;
        }
        DurationFieldType durationFieldType = arg0.getDurationType();
        if (DATE_DURATION_TYPES.contains(durationFieldType) || durationFieldType.getField(this.getChronology()).getUnitMillis() >= this.getChronology().days().getUnitMillis()) {
            return arg0.getField(this.getChronology()).isSupported();
        }
        return false;
    }

    public int getValue(int arg0) {
        switch (arg0) {
            case 0: {
                return this.getChronology().year().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().monthOfYear().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().dayOfMonth().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + arg0);
    }

    public LocalDate withCenturyOfEra(int arg0) {
        return this.withLocalMillis(this.getChronology().centuryOfEra().set(this.getLocalMillis(), arg0));
    }

    public static LocalDate fromCalendarFields(Calendar arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        int n = arg0.get(0);
        int n2 = arg0.get(1);
        return new LocalDate(n == 1 ? n2 : 1 - n2, arg0.get(2) + 1, arg0.get(5));
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public LocalDate plusMonths(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().months().add(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    public int getMonthOfYear() {
        return this.getChronology().monthOfYear().get(this.getLocalMillis());
    }

    protected long getLocalMillis() {
        return this.iLocalMillis;
    }

    public LocalDate withDayOfYear(int arg0) {
        return this.withLocalMillis(this.getChronology().dayOfYear().set(this.getLocalMillis(), arg0));
    }

    public LocalDate withDayOfMonth(int arg0) {
        return this.withLocalMillis(this.getChronology().dayOfMonth().set(this.getLocalMillis(), arg0));
    }

    public int getYearOfCentury() {
        return this.getChronology().yearOfCentury().get(this.getLocalMillis());
    }

    @Deprecated
    public DateTime toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    public LocalDate() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public LocalDate withEra(int arg0) {
        return this.withLocalMillis(this.getChronology().era().set(this.getLocalMillis(), arg0));
    }

    public LocalDate withField(DateTimeFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(arg0)) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        long l2 = arg0.getField(this.getChronology()).set(this.getLocalMillis(), arg1);
        return this.withLocalMillis(l2);
    }

    public LocalDate withFieldAdded(DurationFieldType arg0, int arg1) {
        if (arg0 == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(arg0)) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        if (arg1 == 0) {
            return this;
        }
        long l2 = arg0.getField(this.getChronology()).add(this.getLocalMillis(), arg1);
        return this.withLocalMillis(l2);
    }

    public int getEra() {
        return this.getChronology().era().get(this.getLocalMillis());
    }

    public int getYearOfEra() {
        return this.getChronology().yearOfEra().get(this.getLocalMillis());
    }

    public static LocalDate parse(String arg0, DateTimeFormatter arg1) {
        return arg1.parseLocalDate(arg0);
    }

    private Object readResolve() {
        LocalDate a2;
        if (a2.iChronology == null) {
            return new LocalDate(a2.iLocalMillis, (Chronology)ISOChronology.getInstanceUTC());
        }
        if (!DateTimeZone.UTC.equals(a2.iChronology.getZone())) {
            return new LocalDate(a2.iLocalMillis, a2.iChronology.withUTC());
        }
        return a2;
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 instanceof LocalDate) {
            LocalDate localDate = (LocalDate)arg0;
            if (this.iChronology.equals(localDate.iChronology)) {
                return this.iLocalMillis == localDate.iLocalMillis;
            }
        }
        return super.equals(arg0);
    }

    public LocalDate minusDays(int arg0) {
        if (arg0 == 0) {
            return this;
        }
        long l2 = this.getChronology().days().subtract(this.getLocalMillis(), arg0);
        return this.withLocalMillis(l2);
    }

    @ToString
    public String toString() {
        return ISODateTimeFormat.date().print(this);
    }

    public Chronology getChronology() {
        return this.iChronology;
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    public LocalDate(long arg0) {
        this(arg0, (Chronology)ISOChronology.getInstance());
    }

    public LocalDate withPeriodAdded(ReadablePeriod arg0, int arg1) {
        if (arg0 == null || arg1 == 0) {
            return this;
        }
        long l2 = this.getLocalMillis();
        Chronology chronology = this.getChronology();
        for (int i2 = 0; i2 < arg0.size(); ++i2) {
            long l3 = FieldUtils.safeMultiply(arg0.getValue(i2), arg1);
            DurationFieldType durationFieldType = arg0.getFieldType(i2);
            if (!this.isSupported(durationFieldType)) continue;
            l2 = durationFieldType.getField(chronology).add(l2, l3);
        }
        return this.withLocalMillis(l2);
    }

    public Property property(DateTimeFieldType arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(arg0)) {
            throw new IllegalArgumentException("Field '" + arg0 + "' is not supported");
        }
        return new Property(this, arg0.getField(this.getChronology()));
    }

    public static LocalDate now() {
        return new LocalDate();
    }

    public DateTime toDateTimeAtStartOfDay() {
        return this.toDateTimeAtStartOfDay(null);
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public int getCenturyOfEra() {
        return this.getChronology().centuryOfEra().get(this.getLocalMillis());
    }

    public int hashCode() {
        int n = this.iHash;
        if (n == 0) {
            n = this.iHash = super.hashCode();
        }
        return n;
    }

    public LocalDateTime toLocalDateTime(LocalTime arg0) {
        if (arg0 == null) {
            throw new IllegalArgumentException("The time must not be null");
        }
        if (this.getChronology() != arg0.getChronology()) {
            throw new IllegalArgumentException("The chronology of the time does not match");
        }
        long l2 = this.getLocalMillis() + arg0.getLocalMillis();
        return new LocalDateTime(l2, this.getChronology());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private transient DateTimeField iField;
        private transient LocalDate iInstant;
        private static final long serialVersionUID = -3193829732634L;

        public LocalDate setCopy(int arg0) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), arg0));
        }

        Property(LocalDate a2, DateTimeField a3) {
            Property a4;
            a4.iInstant = a2;
            a4.iField = a3;
        }

        public LocalDate roundCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalDate setCopy(String arg0) {
            return this.setCopy(arg0, null);
        }

        public LocalDate roundHalfEvenCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfEven(this.iInstant.getLocalMillis()));
        }

        public LocalDate setCopy(String arg0, Locale arg1) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), arg0, arg1));
        }

        public LocalDate addWrapFieldToCopy(int arg0) {
            return this.iInstant.withLocalMillis(this.iField.addWrapField(this.iInstant.getLocalMillis(), arg0));
        }

        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public LocalDate getLocalDate() {
            return this.iInstant;
        }

        private void writeObject(ObjectOutputStream a2) throws IOException {
            Property a3;
            a2.writeObject(a3.iInstant);
            a2.writeObject(a3.iField.getType());
        }

        public LocalDate roundHalfFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfFloor(this.iInstant.getLocalMillis()));
        }

        public LocalDate addToCopy(int arg0) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), arg0));
        }

        private void readObject(ObjectInputStream a2) throws IOException, ClassNotFoundException {
            Property a3;
            a3.iInstant = (LocalDate)a2.readObject();
            DateTimeFieldType dateTimeFieldType = (DateTimeFieldType)a2.readObject();
            a3.iField = dateTimeFieldType.getField(a3.iInstant.getChronology());
        }

        public LocalDate roundFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundFloor(this.iInstant.getLocalMillis()));
        }

        public LocalDate roundHalfCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfCeiling(this.iInstant.getLocalMillis()));
        }

        protected long getMillis() {
            return this.iInstant.getLocalMillis();
        }

        public LocalDate withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public DateTimeField getField() {
            return this.iField;
        }

        public LocalDate withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }
    }
}

