/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.test.distribution.normality;

import dev.nm.stat.descriptive.moment.Kurtosis;
import dev.nm.stat.descriptive.moment.Skewness;
import dev.nm.stat.distribution.univariate.ChiSquareDistribution;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.test.HypothesisTest;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DAgostino
extends HypothesisTest {
    private final Kurtosis if;
    private final Skewness new;

    public DAgostino(double[] sample) {
        super(new double[][]{sample});
        this.new = new Skewness(sample);
        this.if = new Kurtosis(sample);
    }

    @Override
    public String getNullHypothesis() {
        return "both the skewness and the excess kurtosis are 0";
    }

    @Override
    public double statistics() {
        double a2 = this.Z1();
        double a3 = this.Z2();
        double a4 = a2 * a2 + a3 * a3;
        return a4;
    }

    @Override
    public double pValue() {
        ChiSquareDistribution a2 = new ChiSquareDistribution(2.0);
        double a3 = DAgostino.oneSidedPvalue(a2, this.statistics());
        return a3;
    }

    public double Z2() {
        int a2 = this.nObs();
        double a3 = this.if.sample() + 3.0;
        double a4 = 3.0 * (double)(a2 - 1) / (double)(a2 + 1);
        double a5 = 24.0 * (double)a2 * (double)(a2 - 2) * (double)(a2 - 3);
        double a6 = (a3 - a4) / Math.sqrt(a5 /= (double)((a2 + 1) * (a2 + 1) * (a2 + 3) * (a2 + 5)));
        double a7 = 6.0 * (double)(a2 * a2 - 5 * a2 + 2);
        a7 /= (double)((a2 + 7) * (a2 + 9));
        a7 *= Math.sqrt(6 * (a2 + 3) * (a2 + 5));
        double a8 = 1.0 + 4.0 / (a7 /= Math.sqrt(a2 * (a2 - 2) * (a2 - 3))) / a7;
        a8 = Math.sqrt(a8);
        a8 += 2.0 / a7;
        a8 *= 8.0 / a7;
        double a9 = 1.0 - 2.0 / (a8 += 6.0);
        a9 /= 1.0 + a6 * Math.sqrt(2.0 / (a8 - 4.0));
        a9 = -1.0 * Math.cbrt(a9);
        a9 += 1.0 - 0.2222222222222222 / a8;
        return a9 /= Math.sqrt(0.2222222222222222 / a8);
    }

    public double pvalueZ1() {
        NormalDistribution a2 = new NormalDistribution();
        double a3 = 2.0 * (1.0 - a2.cdf(Math.abs(this.Z1())));
        return a3;
    }

    public double pvalueZ2() {
        NormalDistribution a2 = new NormalDistribution();
        double a3 = 2.0 * (1.0 - a2.cdf(Math.abs(this.Z2())));
        return a3;
    }

    public double Z1() {
        int a2 = this.nObs();
        double a3 = this.new.sample();
        double a4 = (double)((a2 + 1) * (a2 + 3)) / 6.0 / (double)(a2 - 2);
        a4 = Math.sqrt(a4);
        a4 *= a3;
        double a5 = 3.0 * (double)(a2 * a2 + 27 * a2 - 70) * (double)(a2 + 1) * (double)(a2 + 3);
        double a6 = -1.0;
        double a7 = Math.sqrt(a6 += Math.sqrt(2.0 * (a5 /= (double)((a2 - 2) * (a2 + 5) * (a2 + 7) * (a2 + 9))) - 2.0));
        double a8 = 1.0 / Math.sqrt(Math.log(a7));
        double a9 = Math.sqrt(2.0 / (a6 - 1.0));
        double a10 = a8;
        return a10 *= Math.log(a4 / a9 + Math.sqrt(a4 * a4 / a9 / a9 + 1.0));
    }

    @Override
    public String getAlternativeHypothesis() {
        return "either the skewness or the excess kurtosis is non-zero";
    }
}

