/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.regression.linear.lasso.lars;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.factorization.qr.QR;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.BackwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.linearsystem.ForwardSubstitution;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.DenseMatrix;
import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.triangle.UpperTriangularMatrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.matrix.doubles.operation.SubMatrixRef;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.algebra.linear.vector.doubles.operation.VectorFactory;
import dev.nm.algebra.structure.AbelianGroup;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.misc.algorithm.ActiveSet;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.stat.descriptive.rank.Min;
import dev.nm.stat.regression.linear.lasso.lars.LARSProblem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LARSFitting {
    private final int void;
    private final double if;
    private final LARSProblem new;

    private static UpperTriangularMatrix final(UpperTriangularMatrix a2, int a3) {
        int[] a4 = DoubleUtils.seq(1, a2.nRows());
        int[] a5 = LARSFitting.final(a4, a3);
        UpperTriangularMatrix a6 = null;
        if (a5.length > 0) {
            SubMatrixRef a7 = new SubMatrixRef(a2, a4, a5);
            a6 = new QR(a7).R();
        }
        return a6;
    }

    public LARSFitting(LARSProblem problem) {
        this(problem, 10 * Math.min(problem.m(), problem.nObs()));
    }

    private static UpperTriangularMatrix final(UpperTriangularMatrix a2, Vector a3, double a4) {
        if (a2 == null) {
            double a5 = Math.sqrt(a4);
            UpperTriangularMatrix a6 = new UpperTriangularMatrix(new double[][]{{a5}});
            return a6;
        }
        Vector a7 = new ForwardSubstitution().solve(a2.t(), a3);
        double a8 = a7.innerProduct(a7);
        double a9 = a4 - a8;
        a9 = a9 <= Constants.EPSILON ? Constants.EPSILON : Math.sqrt(a9);
        int a10 = a2.nRows() + 1;
        Matrix a11 = a2;
        a11 = MatrixFactory.cbind(a11, new DenseMatrix(a7));
        a11 = MatrixFactory.rbind(a11, new DenseMatrix(DoubleUtils.rep(0.0, a10), 1, a10));
        a11.set(a10, a10, a9);
        UpperTriangularMatrix a12 = new UpperTriangularMatrix(a11);
        return a12;
    }

    public Estimators getEstimators() {
        Vector a2;
        double a3;
        this.final();
        int a4 = this.new.nObs();
        int a5 = this.new.m();
        boolean a6 = this.new.isLASSO();
        Matrix a7 = this.new.XLARS();
        Vector a8 = this.new.yLARS();
        Matrix a9 = a7.t().multiply(a7);
        Vector a10 = a7.t().multiply(a8);
        ActiveSet a11 = new ActiveSet(false);
        a11.addInactive(DoubleUtils.seq(1, a5));
        ArrayList<Integer> a12 = new ArrayList<Integer>();
        int a13 = 0;
        UpperTriangularMatrix a14 = null;
        ArrayList<DenseVector> a15 = new ArrayList<DenseVector>();
        a15.add(new DenseVector(a5));
        ArrayList<Double> a16 = new ArrayList<Double>();
        ArrayList<Double> a17 = new ArrayList<Double>();
        ArrayList<Double> a18 = new ArrayList<Double>();
        ArrayList<Integer> a19 = new ArrayList<Integer>();
        for (int a20 = 0; a11.activeSize() < a5 && a20 < this.void && !((a3 = (a2 = VectorFactory.subVector(a10, a11.getInactiveIndices())).norm(Double.POSITIVE_INFINITY)) < 10.0 * this.if); ++a20) {
            double a21;
            int a22;
            DenseVector a23;
            int a24;
            AbelianGroup<Matrix> a25;
            double a26;
            int a27 = -a13;
            if (a13 == 0) {
                int a28 = 1 + DoubleUtils.maxIndex(DoubleArrayMath.abs(a2.toArray()));
                a2 = VectorFactory.subVector(a2, LARSFitting.final(DoubleUtils.seq(1, a2.size()), a28));
                int a29 = a11.getInactive(a28);
                a14 = LARSFitting.final(a14, VectorFactory.subVector(a9.getRow(a29), a11.getActiveIndices()), a9.get(a29, a29));
                a27 = a29;
                a11.addActive(a29);
                a12.add(a10.get(a29) > 0.0 ? 1 : -1);
            }
            DenseVector a30 = new DenseVector(DoubleUtils.collection2IntArray(a12));
            Vector a31 = new ForwardSubstitution().solve(a14.t(), a30);
            Vector a32 = new BackwardSubstitution().solve(a14, a31);
            double a33 = a32.innerProduct(a30);
            double a34 = 1.0 / Math.sqrt(a33);
            Vector a35 = a32.scaled(a34);
            if (a11.activeSize() >= Math.min(a5, a4)) {
                a26 = a3 / a34;
            } else {
                a25 = new SubMatrixRef(a9, a11.getActiveIndices(), a11.getInactiveIndices());
                Vector a36 = a25.t().multiply(a35);
                a24 = a36.size();
                a23 = new DenseVector(2 * a24);
                for (a22 = 1; a22 <= a24; ++a22) {
                    a23.set(2 * a22 - 1, (a3 - a2.get(a22)) / (a34 - a36.get(a22)));
                    a23.set(2 * a22, (a3 + a2.get(a22)) / (a34 + a36.get(a22)));
                }
                for (a22 = 1; a22 <= a23.size(); ++a22) {
                    if (!(a23.get(a22) <= 0.0)) continue;
                    a23.set(a22, Double.MAX_VALUE);
                }
                a26 = new Min(a23.toArray()).value();
            }
            a25 = a15.size() > 0 ? (Vector)a15.get(a15.size() - 1) : new DenseVector(a5);
            int a37 = 0;
            if (a6) {
                a24 = a11.activeSize();
                a23 = new DenseVector(a24 + 1);
                for (a22 = 1; a22 <= a24; ++a22) {
                    a21 = a35.get(a22);
                    double a38 = -a25.get(a11.getActive(a22)) / a21;
                    a23.set(a22, a38 > 0.0 ? a38 : Double.MAX_VALUE);
                }
                a23.set(a24 + 1, a26);
                double a39 = a23.norm(Double.NEGATIVE_INFINITY);
                a13 = 0;
                a37 = 0;
                if (a39 < a26) {
                    a26 = a39;
                    a37 = 1 + DoubleUtils.minIndex(DoubleArrayMath.abs(a23.toArray()));
                    a13 = a11.getActive(a37);
                }
            }
            a16.add(a3);
            a17.add(a26);
            a18.add(a34);
            a19.add(a27);
            Vector a40 = new SubMatrixRef(a9, DoubleUtils.seq(1, a5), a11.getActiveIndices()).multiply(a35);
            a40 = a40.scaled(a26);
            a10 = a10.minus(a40);
            a23 = new DenseVector(a5);
            for (a22 = 1; a22 <= a5; ++a22) {
                a23.set(a22, a25.get(a22));
            }
            for (a22 = 1; a22 <= a11.activeSize(); ++a22) {
                a21 = a35.get(a22);
                a23.set(a11.getActive(a22), a23.get(a11.getActive(a22)) + a26 * a21);
            }
            if (a6 && a13 != 0) {
                a14 = LARSFitting.final(a14, a37);
                a23.set(a13, 0.0);
                a11.removeActive(a13);
                a12.set(a37 - 1, 0);
                a12.remove((Object)0);
            }
            a15.add(a23);
        }
        Estimators a41 = new Estimators(this.new, a15, a16, a17, a18, a19);
        return a41;
    }

    private static int[] final(int[] a2, int a3) {
        List<Integer> a4 = DoubleUtils.intArray2List(a2);
        a4.remove((Object)a3);
        return DoubleUtils.collection2IntArray(a4);
    }

    public LARSFitting(LARSProblem problem, double epsilon, int maxIterations) {
        this.new = problem;
        this.if = epsilon;
        this.void = maxIterations;
    }

    private boolean final() {
        LARSFitting a2;
        ArgumentAssertion.assertPositive(a2.new.nObs(), "n > 0");
        ArgumentAssertion.assertPositive(a2.new.m(), "m > 0");
        Vector a3 = a2.new.XL2Norm();
        for (int a4 = 1; a4 <= a2.new.m(); ++a4) {
            ArgumentAssertion.assertTrue(a3.get(a4) > a2.if * Math.sqrt(a2.new.nObs()), "at least one of the covariates is effectively 0; remove such column(s) from the predictors", new Object[0]);
        }
        return true;
    }

    public LARSFitting(LARSProblem problem, int maxIterations) {
        this(problem, 10.0 * Constants.EPSILON, maxIterations);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Estimators {
        private final Vector short;
        private final List<Double> enum;
        private final List<Double> false;
        private final List<Double> void;
        private final List<Integer> if;
        private final List<Vector> new;

        public Matrix scaledBetas() {
            int a2 = this.new.size();
            int a3 = this.new.get(0).size();
            Vector[] a4 = new Vector[a2];
            for (int a5 = 1; a5 <= a2; ++a5) {
                a4[a5 - 1] = this.new.get(a5 - 1);
                for (int a6 = 1; a6 <= a3; ++a6) {
                    a4[a5 - 1].set(a6, a4[a5 - 1].get(a6) / this.short.get(a6));
                }
            }
            Matrix a7 = MatrixFactory.rbind(a4);
            return a7;
        }

        public List<Double> A() {
            return Collections.unmodifiableList(this.enum);
        }

        public List<Double> gamma() {
            return Collections.unmodifiableList(this.void);
        }

        public List<Vector> betas() {
            return Collections.unmodifiableList(this.new);
        }

        public List<Double> max_abs_cor() {
            return Collections.unmodifiableList(this.false);
        }

        private Estimators(LARSProblem a2, List<Vector> a3, List<Double> a4, List<Double> a5, List<Double> a6, List<Integer> a7) {
            Estimators a8;
            a8.new = new ArrayList<Vector>(a3);
            a8.false = new ArrayList<Double>(a4);
            a8.void = new ArrayList<Double>(a5);
            a8.enum = new ArrayList<Double>(a6);
            a8.if = new ArrayList<Integer>(a7);
            a8.short = a2.XL2Norm();
        }

        public List<Integer> actions() {
            return Collections.unmodifiableList(this.if);
        }
    }
}

