/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.hmm.mixture.distribution;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.distribution.univariate.LogNormalDistribution;
import dev.nm.stat.distribution.univariate.ProbabilityDistribution;
import dev.nm.stat.hmm.mixture.distribution.MixtureDistribution;
import dev.nm.stat.random.rng.univariate.LogNormalRNG;
import dev.nm.stat.random.rng.univariate.RandomNumberGenerator;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LogNormalMixtureDistribution
implements MixtureDistribution {
    private final boolean void;
    private final boolean if;
    private final Lambda[] new;

    @Override
    public RandomNumberGenerator[] newRandomNumberGenerators() {
        RandomNumberGenerator[] a2 = new RandomNumberGenerator[this.new.length];
        for (int a3 = 0; a3 < this.new.length; ++a3) {
            double a4 = this.new[a3].logMu;
            double a5 = this.new[a3].logSigma;
            a2[a3] = new LogNormalRNG(a4, a5);
        }
        return a2;
    }

    public Lambda[] getMStepParams(double[] observations, Vector[] u) {
        int a2 = u.length;
        int a3 = u[0].size();
        double[] a4 = DoubleUtils.foreach(observations, new AbstractUnivariateRealFunction(){
            {
                1 a3;
            }

            @Override
            public double evaluate(double x) {
                return Math.log(x);
            }
        });
        Lambda[] a5 = new Lambda[this.new.length];
        for (int a6 = 0; a6 < a3; ++a6) {
            double a7;
            double a8;
            double a9 = this.new[a6].logMu;
            if (this.if) {
                a8 = 0.0;
                a7 = 0.0;
                for (int a10 = 0; a10 < a2; ++a10) {
                    double a11 = u[a10].get(a6 + 1);
                    a8 += a11 * a4[a10];
                    a7 += a11;
                }
                a9 = a8 / a7;
            }
            a8 = this.new[a6].logSigma;
            if (this.void) {
                a7 = 0.0;
                double a12 = 0.0;
                for (int a13 = 1; a13 <= a2; ++a13) {
                    double a14 = u[a13 - 1].get(a6 + 1);
                    double a15 = a4[a13 - 1] - a9;
                    a7 += a14 * a15 * a15;
                    a12 += a14;
                }
                a8 = Math.sqrt(a7 / a12);
            }
            a5[a6] = new Lambda(a9, a8);
        }
        return a5;
    }

    @Override
    public ProbabilityDistribution[] newDistributions() {
        ProbabilityDistribution[] a2 = new ProbabilityDistribution[this.new.length];
        for (int a3 = 0; a3 < this.new.length; ++a3) {
            double a4 = this.new[a3].logMu;
            double a5 = this.new[a3].logSigma;
            a2[a3] = new LogNormalDistribution(a4, a5);
        }
        return a2;
    }

    public Lambda[] getParams() {
        Lambda[] a2 = Arrays.copyOf(this.new, this.new.length);
        return a2;
    }

    public LogNormalMixtureDistribution(Lambda[] lambda, boolean isMuEstimated, boolean isSigmaEstimated) {
        this.new = Arrays.copyOf(lambda, lambda.length);
        this.if = isMuEstimated;
        this.void = isSigmaEstimated;
    }

    public LogNormalMixtureDistribution(Lambda[] lambda) {
        this(lambda, true, true);
    }

    @Override
    public MixtureDistribution newMixtureDistribution(Object[] param) {
        Lambda[] a2 = Arrays.copyOf((Lambda[])param, param.length);
        return new LogNormalMixtureDistribution(a2, this.if, this.void);
    }

    public static class Lambda {
        public final double logMu;
        public final double logSigma;

        public Lambda(double mu, double sigma) {
            this.logMu = mu;
            this.logSigma = sigma;
        }
    }
}

