/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.evt.evd.bivariate;

import dev.nm.analysis.function.rn2r1.univariate.AbstractUnivariateRealFunction;
import dev.nm.analysis.root.univariate.BrentRoot;
import dev.nm.analysis.root.univariate.NoRootFoundException;
import dev.nm.analysis.root.univariate.Uniroot;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;
import dev.nm.misc.license.Package;
import dev.nm.stat.distribution.univariate.NormalDistribution;
import dev.nm.stat.evt.evd.bivariate.AbstractBivariateEVD;
import dev.nm.stat.evt.evd.univariate.GeneralizedEVD;
import dev.nm.stat.random.rng.univariate.uniform.UniformRNG;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BivariateEVDHuslerReiss
extends AbstractBivariateEVD {
    private static final Uniroot enum;
    private final UniformRNG false = new UniformRNG();
    private final GeneralizedEVD void;
    private final GeneralizedEVD if;
    private final double new;

    @Override
    public double[] nextVector() {
        double a2;
        final double[] a3 = new double[]{this.false.nextDouble(), this.false.nextDouble()};
        AbstractUnivariateRealFunction a4 = new AbstractUnivariateRealFunction(){
            {
                1 a32;
            }

            @Override
            public double evaluate(double x) {
                return BivariateEVDHuslerReiss.this.final(x, a3[1]) - a3[0];
            }
        };
        try {
            a2 = enum.solve(a4, Constants.MACH_EPS, 1.0 - Constants.MACH_EPS, new double[0]);
        }
        catch (NoRootFoundException a5) {
            a2 = a5.x();
        }
        a3[0] = a2;
        double a6 = this.if.marginalInverseTransform(-Math.log(a3[0]));
        double a7 = this.void.marginalInverseTransform(-Math.log(a3[1]));
        return new double[]{a6, a7};
    }

    private double final(double a2, double a3) {
        BivariateEVDHuslerReiss a4;
        double a5 = -Math.log(a2);
        double a6 = -Math.log(a3);
        double a7 = 1.0 / a4.new;
        NormalDistribution a8 = new NormalDistribution();
        double a9 = a6 * a8.cdf(a7 + (Math.log(a6) - Math.log(a5)) * a4.new / 2.0) + a5 * a8.cdf(a7 + (Math.log(a5) - Math.log(a6)) * a4.new / 2.0);
        double a10 = a8.cdf(a7 + (Math.log(a6) - Math.log(a5)) * a4.new / 2.0) * Math.exp(-a9) / a3;
        return a10;
    }

    public BivariateEVDHuslerReiss(double dependence) {
        this(dependence, new GeneralizedEVD());
    }

    public BivariateEVDHuslerReiss(double dependence, GeneralizedEVD marginal1, GeneralizedEVD marginal2) {
        ArgumentAssertion.assertPositive(dependence, "dependence");
        this.new = dependence;
        this.if = marginal1;
        this.void = marginal2;
    }

    @Override
    public double dependence(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = 1.0 - x;
        return x * new NormalDistribution().cdf(1.0 / this.new + this.new * Math.log(x / (1.0 - x)) / 2.0) + a2 * new NormalDistribution().cdf(1.0 / this.new + this.new * Math.log(a2 / (1.0 - a2)) / 2.0);
    }

    static {
        Package.validate("NMDEV_EVT");
        enum = new BrentRoot(Constants.EPSILON, Integer.MAX_VALUE);
    }

    @Override
    public void seed(long ... seeds) {
        this.false.seed(seeds);
    }

    @Override
    public double cdf(double x1, double x2) {
        double a2 = this.if.marginalTransform(x1);
        double a3 = this.void.marginalTransform(x2);
        NormalDistribution a4 = new NormalDistribution();
        double a5 = a2 * a4.cdf(1.0 / this.new + this.new * Math.log(a2 / a3) / 2.0) + a3 * a4.cdf(1.0 / this.new + this.new * Math.log(a3 / a2) / 2.0);
        double a6 = Math.exp(-a5);
        return a6;
    }

    @Override
    public double spectralDensity(double x) {
        ArgumentAssertion.assertRange(x, 0.0, 1.0, "x");
        double a2 = this.new * new NormalDistribution().density(1.0 / this.new + this.new * Math.log(x / (1.0 - x)) / 2.0);
        return a2 /= 2.0 * x * (1.0 - x) * (1.0 - x);
    }

    public BivariateEVDHuslerReiss(double dependence, GeneralizedEVD marginal) {
        this(dependence, marginal, marginal);
    }

    @Override
    public double density(double x1, double x2) {
        double a2;
        double a3 = this.if.marginalTransform(x1);
        double a4 = this.void.marginalTransform(x2);
        if (a3 == 0.0 || a4 == 0.0 || Double.isInfinite(a3) || Double.isInfinite(a4)) {
            a2 = Double.NEGATIVE_INFINITY;
        } else {
            NormalDistribution a5 = new NormalDistribution();
            double a6 = a3 * a5.cdf(1.0 / this.new + this.new * Math.log(a3 / a4) / 2.0) + a4 * a5.cdf(1.0 / this.new + this.new * Math.log(a4 / a3) / 2.0);
            double a7 = a3 * a5.cdf(1.0 / this.new + this.new * Math.log(a3 / a4) / 2.0) * (a4 * a5.cdf(1.0 / this.new + this.new * Math.log(a4 / a3) / 2.0)) + this.new * (a3 * a5.density(1.0 / this.new + this.new * Math.log(a3 / a4) / 2.0)) / 2.0;
            double a8 = Math.log(a3);
            double a9 = Math.log(a4);
            double a10 = this.if.getShape() * a8 + this.void.getShape() * a9 - Math.log(this.if.getScale() * this.void.getScale());
            a2 = Math.log(a7) + a10 - a6;
        }
        return Math.exp(a2);
    }

    @Override
    public double conditionalCopula(double x1, double x2) {
        ArgumentAssertion.assertRangeOpen(x1, 0.0, 1.0, "x1");
        ArgumentAssertion.assertRangeOpen(x2, 0.0, 1.0, "x2");
        return this.final(x1, x2);
    }
}

