/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.stat.descriptive.rank;

import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import dev.nm.stat.descriptive.Statistic;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Quantile
implements Statistic {
    private double[] if;
    private final QuantileType new;

    private double char(double a2, double a3, double a4) {
        double a5 = a3 + a2 * (1.0 - a3 - a4);
        return a5;
    }

    public double value(double q) {
        ArgumentAssertion.assertRange(q, 0.0, 1.0, "q");
        int a2 = 0;
        double a3 = 0.0;
        double a4 = 0.0;
        double a5 = 0.0;
        double a6 = 0.0;
        switch (this.new) {
            case INVERSE_OF_EMPIRICAL_CDF: {
                a3 = 0.0;
                a2 = this.final(q, a3);
                a4 = this.final(q, a3, a2);
                a5 = DoubleUtils.isZero(a4, 0.0) ? 0.0 : 1.0;
                break;
            }
            case INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES: {
                a3 = 0.0;
                a2 = this.final(q, a3);
                a4 = this.final(q, a3, a2);
                a5 = DoubleUtils.isZero(a4, 0.0) ? 0.5 : 1.0;
                break;
            }
            case NEAREST_EVEN_ORDER_STATISTICS: {
                a3 = -0.5;
                a2 = this.final(q, a3);
                a4 = this.final(q, a3, a2);
                a5 = DoubleUtils.isZero(a4, 0.0) ? (a2 % 2 == 0 ? 0.0 : 1.0) : 1.0;
                break;
            }
            case LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF: {
                a3 = 0.0;
                a2 = this.final(q, a3);
                a5 = a4 = this.final(q, a3, a2);
                break;
            }
            case MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF: {
                a3 = 0.5;
                a2 = this.final(q, a3);
                a5 = a4 = this.final(q, a3, a2);
                break;
            }
            case MINITAB_SPSS: {
                a3 = q;
                a2 = this.final(q, a3);
                a5 = a4 = this.final(q, a3, a2);
                break;
            }
            case S: {
                a3 = 1.0 - q;
                a2 = this.final(q, a3);
                a5 = a4 = this.final(q, a3, a2);
                break;
            }
            case APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL: {
                a3 = this.char(q, 0.375, 0.375);
                a2 = this.final(q, a3);
                a5 = a4 = this.final(q, a3, a2);
                break;
            }
            default: {
                a3 = this.char(q, 0.3333333333333333, 0.3333333333333333);
                a2 = this.final(q, a3);
                a5 = a4 = this.final(q, a3, a2);
            }
        }
        a6 = this.final(a5, a2);
        return a6;
    }

    public Quantile(double[] data) {
        this(data, QuantileType.APPROXIMATELY_MEDIAN_UNBIASED);
    }

    @Override
    public double value() {
        throw new UnsupportedOperationException("you must supply a quantile value q");
    }

    private int final(double a2, double a3) {
        Quantile a4;
        int a5 = a4.if.length;
        int a6 = (int)Math.floor(a2 * (double)a5 + a3);
        a6 = a6 > 0 ? a6 : 0;
        a6 = a6 <= a5 ? a6 : a5;
        return a6;
    }

    public Quantile(double[] data, QuantileType type) {
        this.new = type;
        this.addData(data);
    }

    @Override
    public long N() {
        return this.if.length;
    }

    static {
        Package.validate("NMDEV_BASIC");
    }

    private double final(double a2, double a3, double a4) {
        Quantile a5;
        int a6 = a5.if.length;
        double a7 = a2 * (double)a6 + a3 - a4;
        return a7;
    }

    @Override
    public void addData(double ... data) {
        int a2 = this.if == null ? 0 : this.if.length;
        this.if = this.if == null ? new double[data.length] : Arrays.copyOf(this.if, this.if.length + data.length);
        for (int a3 = 0; a3 < data.length; ++a3) {
            this.if[a2 + a3] = data[a3];
        }
        Arrays.sort(this.if);
    }

    private double final(double a2, int a3) {
        Quantile a4;
        double a5 = (1.0 - a2) * a4.if[a3 > 0 ? a3 - 1 : 0];
        return a5 += a2 * a4.if[a3 < a4.if.length ? a3 : a4.if.length - 1];
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum QuantileType {
        INVERSE_OF_EMPIRICAL_CDF,
        INVERSE_OF_EMPIRICAL_CDF_WITH_AVERAGING_AT_DISCONTINUITIES,
        NEAREST_EVEN_ORDER_STATISTICS,
        LINEAR_INTERPOLATION_OF_EMPIRICAL_CDF,
        MIDWAY_THROUGH_STEPS_OF_EMPIRICAL_CDF,
        MINITAB_SPSS,
        S,
        APPROXIMATELY_MEDIAN_UNBIASED,
        APPROXIMATELY_UNBIASED_IF_DATA_IS_NORMAL;


        private QuantileType() {
            QuantileType a2;
        }
    }
}

