/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.univariate;

import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.parallel.LoopBody;
import dev.nm.misc.parallel.ParallelExecutor;
import dev.nm.number.DoubleUtils;
import dev.nm.number.doublearray.DoubleArrayMath;
import dev.nm.solver.problem.C2OptimProblem;
import dev.nm.solver.univariate.UnivariateMinimizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GridSearchMinimizer
implements UnivariateMinimizer {
    private static final ParallelExecutor if = new ParallelExecutor(GridSearchMinimizer.class.getSimpleName());
    private final GridDefinition new;

    public GridSearchMinimizer(GridDefinition gridDefinition) {
        this.new = gridDefinition;
    }

    public GridSearchMinimizer(double gridSize) {
        this((a3, a4) -> DoubleUtils.seq(a3, a4, gridSize));
    }

    @Override
    public Solution solve(UnivariateRealFunction f2) {
        return new Solution(f2);
    }

    public GridSearchMinimizer(int nPoints) {
        this((a3, a4) -> {
            double a5 = (a4 - a3) / (double)nPoints;
            return DoubleUtils.seq(a3, a4, a5);
        });
        ArgumentAssertion.assertPositive(nPoints, "no. of grid points");
    }

    @Override
    public Solution solve(C2OptimProblem problem) {
        return this.solve((UnivariateRealFunction)problem.f());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class Solution
    implements UnivariateMinimizer.Solution {
        private final UnivariateRealFunction void;
        private double if;
        private double new;

        @Override
        public double search(double lower, double upper) {
            return this.search(lower, Double.NaN, upper);
        }

        @Override
        public double search(double lower, double initial, double upper) {
            ArgumentAssertion.assertTrue(lower < upper, "invalid bracket interval", new Object[0]);
            this.if = Double.POSITIVE_INFINITY;
            final double[] a2 = GridSearchMinimizer.this.new.points(lower, upper);
            try {
                final double[] a3 = new double[a2.length];
                if.forLoop(0, a2.length, new LoopBody(){

                    @Override
                    public void run(int i2) throws Exception {
                        double a22;
                        a3[i2] = a22 = Solution.this.void.evaluate(a2[i2]);
                    }
                    {
                        1 a32;
                    }
                });
                this.if = DoubleArrayMath.min(a3);
                int a4 = DoubleUtils.minIndex(a3);
                this.new = a2[a4];
            }
            catch (Exception a5) {
                for (double a6 : a2) {
                    double a7 = this.void.evaluate(a6);
                    if (!(a7 < this.if)) continue;
                    this.if = a7;
                    this.new = a6;
                }
            }
            return this.new;
        }

        private Solution(UnivariateRealFunction a3) {
            Solution a4;
            a4.void = a3;
        }

        @Override
        public Double minimizer() {
            return this.new;
        }

        @Override
        public double minimum() {
            return this.if;
        }
    }

    public static interface GridDefinition {
        public double[] points(double var1, double var3);
    }
}

