/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.unconstrained.annealing.annealingfunction;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.misc.Constants;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.unconstrained.annealing.annealingfunction.AnnealingFunction;
import dev.nm.solver.multivariate.unconstrained.annealing.annealingfunction.GSAAnnealingFunction;
import dev.nm.stat.random.rng.univariate.RandomLongGenerator;
import dev.nm.stat.random.rng.univariate.normal.Zignor2005;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BoxGSAAnnealingFunction
implements AnnealingFunction {
    private final GSAAnnealingFunction void;
    private final Vector if;
    private final Vector new;

    public BoxGSAAnnealingFunction(Vector lower, Vector upper, double qv, RandomLongGenerator uniform) {
        this.if = lower;
        this.new = upper.minus(lower);
        this.void = new GSAAnnealingFunction(qv, uniform, new Zignor2005(uniform));
    }

    @Override
    public Vector nextProposal(Vector currentState, double temperature) {
        Vector a2 = this.void.nextProposal(currentState, temperature);
        for (int a3 = 1; a3 <= a2.size(); ++a3) {
            double a4 = a2.get(a3) - this.if.get(a3);
            double a5 = DoubleUtils.doubleMod(a4, this.new.get(a3)) + this.new.get(a3);
            double a6 = DoubleUtils.doubleMod(a5, this.new.get(a3)) + this.if.get(a3);
            a2.set(a3, a6);
            if (!(Math.abs(a2.get(a3) - this.if.get(a3)) < Constants.EPSILON)) continue;
            a2.set(a3, a2.get(a3) + Constants.EPSILON);
        }
        return a2;
    }
}

