/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.solver.multivariate.constrained.constraint.linear;

import dev.nm.algebra.linear.matrix.doubles.Matrix;
import dev.nm.algebra.linear.matrix.doubles.operation.MatrixFactory;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.interval.RealInterval;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.number.DoubleUtils;
import dev.nm.solver.multivariate.constrained.constraint.GreaterThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.LessThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearGreaterThanConstraints;
import dev.nm.solver.multivariate.constrained.constraint.linear.LinearLessThanConstraints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BoxConstraints {
    private final int if;
    private final List<Bound> new;

    public List<Bound> bounds() {
        ArrayList<Bound> a2 = new ArrayList<Bound>(this.new.size());
        a2.addAll(this.new);
        return a2;
    }

    public static boolean isInBox(Vector x, Vector lower, Vector upper) {
        for (int a2 = 1; a2 <= x.size(); ++a2) {
            double a3 = x.get(a2);
            if (!(a3 < lower.get(a2)) && !(a3 > upper.get(a2))) continue;
            return false;
        }
        return true;
    }

    public Vector upperBounds() {
        DenseVector a2 = new DenseVector(this.if, Double.POSITIVE_INFINITY);
        for (Bound a3 : this.new) {
            a2.set(a3.index, a3.upper());
        }
        return a2;
    }

    public BoxConstraints(Vector lower, Vector upper) {
        ArgumentAssertion.assertEqual(lower.size(), upper.size(), "the lower and upper bounds must have the same dimension");
        this.if = lower.size();
        this.new = new ArrayList<Bound>(this.if);
        for (int a2 = 1; a2 <= this.if; ++a2) {
            double a3 = lower.get(a2);
            double a4 = upper.get(a2);
            if (Double.NEGATIVE_INFINITY == a3 && Double.POSITIVE_INFINITY == a4) continue;
            Bound a5 = new Bound(a2, a3, a4);
            this.new.add(a5);
        }
    }

    public LinearGreaterThanConstraints lowerBoundConstraints() {
        ArrayList<DenseVector> a3 = new ArrayList<DenseVector>();
        ArrayList<Double> a4 = new ArrayList<Double>();
        for (Bound bound : this.new) {
            Double a5 = bound.lower();
            if (a5 == Double.NEGATIVE_INFINITY || a5 == 0.0) continue;
            a4.add(a5);
            DenseVector a6 = new DenseVector(this.if, 0.0);
            a6.set(bound.index, 1.0);
            a3.add(a6);
        }
        if (a3.isEmpty()) {
            return null;
        }
        Matrix a7 = MatrixFactory.rbind(a3.toArray(new Vector[0]));
        DenseVector denseVector = new DenseVector(DoubleUtils.collection2DoubleArray(a4));
        return new LinearGreaterThanConstraints(a7, denseVector);
    }

    public BoxConstraints(int dim, Bound ... bounds) {
        this.if = dim;
        this.new = new ArrayList<Bound>(bounds.length);
        this.new.addAll(Arrays.asList(bounds));
        Collections.sort(this.new);
    }

    public LinearLessThanConstraints toLessThanConstraints() {
        LinearGreaterThanConstraints a2 = this.lowerBoundConstraints();
        LinearLessThanConstraints a3 = this.upperBoundConstraints();
        LessThanConstraints a4 = a2.toLessThanConstraints();
        LinearLessThanConstraints a5 = (LinearLessThanConstraints)LinearConstraints.concat(new LinearConstraints[]{a3, a4});
        return a5;
    }

    public LinearGreaterThanConstraints toGreaterThanConstraints() {
        LinearLessThanConstraints a2 = this.toLessThanConstraints();
        GreaterThanConstraints a3 = a2.toGreaterThanConstraints();
        return a3;
    }

    public LinearLessThanConstraints upperBoundConstraints() {
        ArrayList<DenseVector> a3 = new ArrayList<DenseVector>();
        ArrayList<Double> a4 = new ArrayList<Double>();
        for (Bound bound : this.new) {
            Double a5 = bound.upper();
            if (a5 == Double.POSITIVE_INFINITY) continue;
            a4.add(a5);
            DenseVector a6 = new DenseVector(this.if, 0.0);
            a6.set(bound.index, 1.0);
            a3.add(a6);
        }
        if (a3.isEmpty()) {
            return null;
        }
        Matrix a7 = MatrixFactory.rbind(a3.toArray(new Vector[0]));
        DenseVector denseVector = new DenseVector(DoubleUtils.collection2DoubleArray(a4));
        return new LinearLessThanConstraints(a7, denseVector);
    }

    public Vector lowerBounds() {
        DenseVector a2 = new DenseVector(this.if, Double.NEGATIVE_INFINITY);
        for (Bound a3 : this.new) {
            a2.set(a3.index, a3.lower());
        }
        return a2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class Bound
    implements Comparable<Bound> {
        public final int index;
        private RealInterval new;

        @Override
        public int compareTo(Bound that) {
            return this.index < that.index ? -1 : (this.index > that.index ? 1 : 0);
        }

        public String toString() {
            return String.format("x[%d]: %s", this.index, this.new.toString());
        }

        public Bound(int index, double lower, double upper) {
            this.index = index;
            this.new = new RealInterval(lower, upper);
        }

        public double lower() {
            return (Double)this.new.begin();
        }

        public double upper() {
            return (Double)this.new.end();
        }
    }
}

