/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.graph;

import dev.nm.graph.Arc;
import dev.nm.graph.DAGraph;
import dev.nm.graph.DiGraph;
import dev.nm.graph.Edge;
import dev.nm.graph.Graph;
import dev.nm.graph.HyperEdge;
import dev.nm.graph.UnDiGraph;
import dev.nm.graph.UndirectedEdge;
import dev.nm.graph.algorithm.traversal.BFS;
import dev.nm.graph.algorithm.traversal.DFS;
import dev.nm.graph.algorithm.traversal.GraphTraversal;
import dev.nm.graph.type.SimpleArc;
import dev.nm.graph.type.SimpleEdge;
import dev.nm.graph.type.SparseDAGraph;
import dev.nm.graph.type.SparseUnDiGraph;
import dev.nm.misc.datastructure.IdentityHashSet;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public final class GraphUtils {
    public static <V> boolean isAcyclic(UnDiGraph<V, UndirectedEdge<V>> g2) {
        int a2;
        int a3 = g2.edges().size();
        return a3 <= (a2 = g2.vertices().size()) - 1;
    }

    public static <V> boolean containsEdge(Graph<V, ?> g2, HyperEdge<V> e2) {
        Set<?> a2 = g2.edges();
        return a2.contains(e2);
    }

    public static <V, E extends UndirectedEdge<V>> List<UnDiGraph<V, E>> getDisjointGraphs(UnDiGraph<V, E> g2) {
        return GraphUtils.getDisjointGraphs(g2, new GraphFactory<UnDiGraph<V, E>>(){

            @Override
            public UnDiGraph<V, E> getGraph() {
                return new SparseUnDiGraph();
            }
            {
                1 a2;
            }
        });
    }

    public static <V> boolean isConnected(UnDiGraph<V, ? extends UndirectedEdge<V>> g2) {
        Set a2 = g2.vertices();
        if (a2.isEmpty()) {
            return true;
        }
        Object a3 = a2.iterator().next();
        List a4 = DFS.DFS(g2, a3, 0);
        return a4.size() == g2.vertices().size();
    }

    public static <V> boolean equals(Graph<V, ?> g1, Graph<V, ?> g2) {
        Set<V> a2;
        Set<V> a3 = g1.vertices();
        if (!a3.equals(a2 = g2.vertices())) {
            return false;
        }
        ArrayList a4 = new ArrayList(g1.edges());
        ArrayList a5 = new ArrayList(g2.edges());
        for (HyperEdge a6 : a4) {
            Set a7 = a6.vertices();
            boolean a8 = false;
            for (HyperEdge a9 : a5) {
                Set a10 = a9.vertices();
                if (!a7.equals(a10)) continue;
                a8 = true;
                break;
            }
            if (a8) continue;
            return false;
        }
        return true;
    }

    public static <V> int numberOfChildren(DiGraph<V, ? extends Arc<V>> g2, V v) {
        return GraphUtils.getChildren(g2, v).size();
    }

    private GraphUtils() {
        GraphUtils a2;
    }

    public static <V> int numberOfParents(DiGraph<V, ? extends Arc<V>> g2, V v) {
        return GraphUtils.getParents(g2, v).size();
    }

    public static <V> Set<V> getNeighbors(Graph<V, ?> g2, V v) {
        Set<?> a2 = g2.edges(v);
        IdentityHashSet a3 = new IdentityHashSet();
        for (HyperEdge a4 : a2) {
            Set<V> a5 = a4.neighbors(v);
            boolean a6 = true;
            for (Object a7 : a5) {
                if (a6 && a7 == v) {
                    a6 = false;
                    continue;
                }
                a3.add(a7);
            }
        }
        return a3;
    }

    public static <V> DAGraph<V, Arc<V>> unDi2DAGraph(UnDiGraph<V, ? extends UndirectedEdge<V>> g2, V root) {
        return GraphUtils.unDi2DAGraph(g2, root, new SimpleArcFactory());
    }

    public static <V> boolean isStronglyConnected(DiGraph<V, ? extends Arc<V>> g2) {
        Set a2 = g2.vertices();
        for (Object a3 : a2) {
            List a4 = DFS.DFS(g2, a3, 0);
            if (a4.size() == g2.vertices().size()) continue;
            return false;
        }
        return true;
    }

    public static <V, E extends UndirectedEdge<V>, G extends UnDiGraph<V, E>> List<G> getDisjointGraphs(UnDiGraph<V, E> g2, GraphFactory<G> gCtor) {
        Object a2;
        Iterator iterator;
        Object a3;
        Object a42;
        ArrayList a5 = new ArrayList();
        IdentityHashSet a6 = new IdentityHashSet();
        for (Object a7 : g2.vertices()) {
            if (a6.contains(a7)) continue;
            a42 = DFS.DFS(g2, a7, 0);
            a3 = new IdentityHashSet();
            iterator = a42.iterator();
            while (iterator.hasNext()) {
                a2 = (DFS.Node)iterator.next();
                a3.add(((GraphTraversal.Node)a2).vertex());
            }
            a5.add(a3);
            a6.addAll(a3);
        }
        ArrayList<G> a8 = new ArrayList<G>();
        for (int a9 = 0; a9 < a5.size(); ++a9) {
            a8.add(gCtor.getGraph());
            a42 = (Set)a5.get(a9);
            a3 = (UnDiGraph)a8.get(a9);
            iterator = a42.iterator();
            while (iterator.hasNext()) {
                a2 = iterator.next();
                a3.addVertex(a2);
            }
        }
        block4: for (Object a42 : g2.edges()) {
            a3 = a42.vertices().iterator().next();
            for (int a10 = 0; a10 < a5.size(); ++a10) {
                if (!((Set)a5.get(a10)).contains(a3)) continue;
                a2 = (UnDiGraph)a8.get(a10);
                a2.addEdge(a42);
                continue block4;
            }
        }
        return a8;
    }

    public static <V, E extends HyperEdge<V>> void addEdges(Graph<V, E> g2, E ... edges) {
        for (E a2 : edges) {
            g2.addEdge(a2);
        }
    }

    public static <V> int numberOfEdges(Graph<V, ?> g2) {
        Set<?> a2 = g2.edges();
        return a2.size();
    }

    public static <V, N, E extends Arc<N>> DAGraph<N, E> unDi2DAGraph(UnDiGraph<V, ? extends UndirectedEdge<V>> g2, V root, EdgeFactory<V, N, E, UndirectedEdge<V>> edgeFactory) {
        BFS.Node<V> a22;
        BFS<V> a3 = new BFS<V>(g2);
        List<BFS.Node<V>> a4 = a3.track(root, 1);
        IdentityHashMap a5 = new IdentityHashMap();
        for (BFS.Node<V> a22 : a4) {
            a5.put(a22.vertex(), a22);
        }
        SparseDAGraph a6 = new SparseDAGraph();
        a22 = a4.get(0);
        Arc a7 = (Arc)edgeFactory.getEdge(a22.vertex(), a22.vertex(), null);
        a6.addVertex(a7.head());
        for (BFS.Node<V> a8 : a4) {
            Object a9 = a8.vertex();
            for (UndirectedEdge a10 : g2.edges(a9)) {
                Object a11;
                Set a12;
                Object a13 = a10.neighbor(a9);
                BFS.Node a14 = (BFS.Node)a5.get(a13);
                if (a8.depth() >= a14.depth()) continue;
                Arc a15 = (Arc)edgeFactory.getEdge(a8.vertex(), a14.vertex(), a10);
                if (a9 != root && (a12 = GraphUtils.getParents(a6, a11 = a15.head())).isEmpty()) {
                    int n = -1;
                }
                a6.addEdge(a15);
            }
        }
        return a6;
    }

    public static <V> UnDiGraph<V, UndirectedEdge<V>> di2UnDiGraph(DiGraph<V, ? extends Arc<V>> diG) {
        SparseUnDiGraph a2 = new SparseUnDiGraph();
        for (Object a3 : diG.edges()) {
            Object a4 = a3.head();
            Object a5 = a3.tail();
            SimpleEdge a6 = new SimpleEdge(a4, a5);
            a2.addEdge(a6);
        }
        for (Object a3 : diG.vertices()) {
            if (a2.contains(a3)) continue;
            a2.addVertex(a3);
        }
        return a2;
    }

    public static <V> int numberOfVertices(Graph<V, ?> g2) {
        Set<V> a2 = g2.vertices();
        return a2.size();
    }

    public static <V> boolean containsVertex(Graph<V, ?> g2, V v) {
        Set<V> a2 = g2.vertices();
        return a2.contains(v);
    }

    public static <V> void addVertices(Graph<V, ?> G2, V ... V) {
        for (V a2 : V) {
            G2.addVertex(a2);
        }
    }

    public static <V> Set<V> getChildren(DiGraph<V, ? extends Arc<V>> g2, V v) {
        IdentityHashSet a2 = new IdentityHashSet();
        Set<Arc<V>> a3 = g2.outgoingArcs(v);
        for (Arc<V> a4 : a3) {
            Set a5 = a4.vertices();
            boolean a6 = true;
            for (Object a7 : a5) {
                if (a6 && a7 == v) {
                    a6 = false;
                    continue;
                }
                a2.add(a7);
            }
        }
        return a2;
    }

    public static <V> Set<V> getParents(DiGraph<V, ? extends Arc<V>> g2, V v) {
        IdentityHashSet a2 = new IdentityHashSet();
        Set<Arc<V>> a3 = g2.incomingArcs(v);
        for (Arc<V> a4 : a3) {
            Set a5 = a4.vertices();
            boolean a6 = true;
            for (Object a7 : a5) {
                if (a6 && a7 == v) {
                    a6 = false;
                    continue;
                }
                a2.add(a7);
            }
        }
        return a2;
    }

    public static <V> Set<HyperEdge<V>> getEdges(Graph<V, ?> g2, V v1, V v2) {
        IdentityHashSet<HyperEdge<V>> a2 = new IdentityHashSet<HyperEdge<V>>();
        Set<?> a3 = g2.edges(v1);
        int a4 = 0;
        for (HyperEdge a5 : a3) {
            Set a6 = a5.vertices();
            for (Object a7 : a6) {
                if (a7 == v1) {
                    ++a4;
                    continue;
                }
                if (a7 != v2) continue;
                ++a4;
            }
            if (a4 != 2) continue;
            a2.add(a5);
        }
        return a2;
    }

    public static <V, E extends HyperEdge<V>> Graph<V, E> removeIsolatedVertices(Graph<V, E> g2) {
        Set<V> a2 = g2.vertices();
        ArrayList<V> a3 = new ArrayList<V>(a2);
        for (Object a4 : a3) {
            if (!g2.edges(a4).isEmpty()) continue;
            g2.removeVertex(a4);
        }
        return g2;
    }

    private static class SimpleArcFactory<V, X>
    implements EdgeFactory<V, V, Arc<V>, X> {
        private SimpleArcFactory() {
            SimpleArcFactory a2;
        }

        @Override
        public Arc<V> getEdge(V v, V u, X info) {
            return new SimpleArc<V>(v, u);
        }
    }

    public static interface EdgeFactory<V, N, E extends Edge<N>, X> {
        public E getEdge(V var1, V var2, X var3);
    }

    public static interface GraphFactory<G> {
        public G getGraph();
    }
}

