/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.root.univariate;

import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.root.univariate.Uniroot;
import dev.nm.misc.Constants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BrentRoot
implements Uniroot {
    private final double if;
    private final int new;

    public BrentRoot(double tol, int maxIterations) {
        this.if = tol;
        this.new = maxIterations;
    }

    public double solve(UnivariateRealFunction f2, double lower, double upper) {
        double a2;
        double a3 = lower;
        double a4 = upper;
        double a5 = a3;
        double a6 = f2.evaluate(a3);
        double a7 = f2.evaluate(a4);
        double a8 = a6;
        if (a6 > 0.0 && a7 > 0.0 || a6 < 0.0 && a7 < 0.0) {
            throw new RuntimeException("[a, b] must bracket the root");
        }
        double a9 = a2 = a4 - a3;
        for (int a10 = 0; a10 < this.new; ++a10) {
            if (a7 > 0.0 && a8 > 0.0 || a7 < 0.0 && a8 < 0.0) {
                a5 = a3;
                a8 = a6;
                a9 = a2 = a4 - a3;
            }
            if (Math.abs(a8) < Math.abs(a7)) {
                a3 = a4;
                a4 = a5;
                a5 = a3;
                a6 = a7;
                a7 = a8;
                a8 = a6;
            }
            double a11 = 0.5 * (a5 - a4);
            if (Math.abs(a7) < this.if || Math.abs(a11) < Constants.EPSILON) break;
            a2 = a11;
            a9 = a2;
            if (Math.abs(a9) >= this.if && Math.abs(a6) > Math.abs(a7)) {
                double a12;
                double a13;
                double a14 = a7 / a6;
                if (a3 == a5) {
                    a13 = 2.0 * a11 * a14;
                    a12 = 1.0 - a14;
                } else {
                    double a15 = a7 / a8;
                    a12 = a6 / a8;
                    a13 = a14 * (2.0 * a11 * a12 * (a12 - a15) - (a4 - a3) * (a15 - 1.0));
                    a12 = (a12 - 1.0) * (a15 - 1.0) * (a14 - 1.0);
                }
                if (a13 > 0.0) {
                    a12 = -a12;
                } else {
                    a13 = -a13;
                }
                if (2.0 * a13 < Math.min(3.0 * a11 * a12 - Math.abs(this.if * a12), Math.abs(a9 * a12))) {
                    a9 = a2;
                    a2 = a13 / a12;
                }
            }
            a3 = a4;
            a6 = a7;
            a4 = Math.abs(a2) > this.if ? (a4 += a2) : (a4 += a11 > 0.0 ? this.if : -this.if);
            a7 = f2.evaluate(a4);
        }
        return a4;
    }

    @Override
    public double solve(UnivariateRealFunction f2, double lower, double upper, double ... guess) {
        return this.solve(f2, lower, upper);
    }
}

