/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentiation;

import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.curvefit.interpolation.NevilleTable;
import dev.nm.analysis.differentiation.multivariate.MultivariateFiniteDifference;
import dev.nm.analysis.differentiation.univariate.FiniteDifference;
import dev.nm.analysis.function.rn2r1.AbstractRealScalarFunction;
import dev.nm.analysis.function.rn2r1.RealScalarFunction;
import dev.nm.analysis.function.rn2r1.univariate.UnivariateRealFunction;
import dev.nm.analysis.function.tuple.PartialFunction;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.Constants;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Ridders
extends AbstractRealScalarFunction {
    private MyFunction float;
    private NevilleTable short;
    private final RealScalarFunction enum;
    private final double false;
    private final int void;
    private static final int if = 15;
    private final int new;

    public Ridders(final RealScalarFunction f2, final int[] varidx, double rate, int discretization) {
        super(f2.dimensionOfDomain());
        this.enum = f2;
        this.void = varidx.length;
        this.false = rate;
        this.new = discretization;
        this.float = new MyFunction(){
            private final MultivariateFiniteDifference new;
            {
                2 a3;
                a3.new = new MultivariateFiniteDifference(a3.f2, a3.varidx);
            }

            @Override
            public double evaluate(Vector x, double h2) {
                return this.new.evaluate(x, h2);
            }
        };
    }

    public double evaluate(Vector x, double h2) {
        double a2 = h2;
        double a3 = this.final(x, a2);
        this.short = new NevilleTable();
        this.short.addData(new PartialFunction(new double[]{a2}, new double[]{a3}));
        double a4 = a3;
        double a5 = Double.MAX_VALUE;
        double a6 = a2;
        for (int a7 = 2; a7 <= this.new; ++a7) {
            double a8 = this.final(x, a6 *= this.false);
            this.short.addData(new PartialFunction(new double[]{a6}, new double[]{a8}));
            this.short.evaluate(0.0);
            for (int a9 = a7 - 2; a9 >= 0; --a9) {
                double a10;
                double a11 = this.short.get(a9, a7 - 1);
                double a12 = Math.abs(a11 - this.short.get(a9, a7 - 2));
                double a13 = Math.max(a12, a10 = Math.abs(a11 - this.short.get(a9 + 1, a7 - 1)));
                if (!(a13 < a5)) continue;
                a4 = a11;
                a5 = a13;
            }
            if (Math.abs(a8 - this.short.get(a7 - 2, a7 - 2)) > 2.0 * a5) break;
        }
        return a4;
    }

    public Ridders(UnivariateRealFunction f2, int order) {
        this(f2, order, 0.75, 15);
    }

    private double final(Vector a2, double a3) {
        Ridders a4;
        double a5 = a4.float.evaluate(a2, a3);
        return a5;
    }

    @Override
    public Double evaluate(Vector x) {
        double a2 = x.norm();
        double a3 = 15.0 * Math.pow(Constants.EPSILON, 1.0 / (double)(this.void + 1)) * Math.max(0.1, a2);
        return this.evaluate(x, a3);
    }

    public Ridders(RealScalarFunction f2, int[] varidx) {
        this(f2, varidx, 0.75, 15);
    }

    public Ridders(final UnivariateRealFunction f2, final int order, double rate, int discretization) {
        super(f2.dimensionOfDomain());
        ArgumentAssertion.assertPositive(order, "the order of derivative");
        this.enum = f2;
        this.void = order;
        this.false = rate;
        this.new = discretization;
        this.float = new MyFunction(){
            private final FiniteDifference new;
            {
                1 a3;
                a3.new = new FiniteDifference(a3.f2, a3.order, FiniteDifference.Type.CENTRAL);
            }

            @Override
            public double evaluate(Vector x, double h2) {
                return this.new.evaluate(x.get(1), h2);
            }
        };
    }

    @Override
    public double evaluate(double x) {
        if (this.enum.dimensionOfDomain() != 1) {
            throw new IllegalArgumentException("f is not a univariate function");
        }
        return this.evaluate(new DenseVector(x));
    }

    private static interface MyFunction {
        public double evaluate(Vector var1, double var2);
    }
}

