/*
 * Decompiled with CFR 0.152.
 */
package dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.heatequation;

import dev.nm.algebra.linear.matrix.doubles.matrixtype.dense.diagonal.TridiagonalMatrix;
import dev.nm.algebra.linear.vector.doubles.Vector;
import dev.nm.algebra.linear.vector.doubles.dense.DenseVector;
import dev.nm.analysis.differentialequation.pde.PDESolver;
import dev.nm.analysis.differentialequation.pde.finitedifference.PDESolutionTimeSpaceGrid1D;
import dev.nm.analysis.differentialequation.pde.finitedifference.PDETimeSpaceGrid1D;
import dev.nm.analysis.differentialequation.pde.finitedifference.parabolic.dim1.heatequation.HeatEquation1D;
import dev.nm.misc.ArgumentAssertion;
import dev.nm.misc.license.Package;
import dev.nm.number.DoubleUtils;
import java.util.Arrays;

public class CrankNicolsonHeatEquation1D
implements PDESolver {
    static {
        Package.validate("NMDEV_OPDE");
    }

    public PDESolutionTimeSpaceGrid1D solve(final HeatEquation1D pde, final int M2, final int N) {
        ArgumentAssertion.assertGreaterThan(M2, 0, "the number of time-axis grid points");
        ArgumentAssertion.assertGreaterThan(N, 0, "the number of space-axis grid points");
        final double[] a2 = DoubleUtils.seq(0.0, pde.T(), M2 + 1);
        final double[] a3 = DoubleUtils.seq(0.0, pde.a(), N + 2);
        final Coefficients a4 = new Coefficients(pde, N, a3[1], a2[1]);
        PDETimeSpaceGrid1D a5 = new PDETimeSpaceGrid1D(M2){

            @Override
            public TridiagonalMatrix getLHS(int m2) {
                TridiagonalMatrix a22 = a4.getLHS();
                return a22;
            }

            @Override
            public void initialCondition() {
                this.u[0] = new DenseVector(N);
                for (int a22 = 1; a22 <= N; ++a22) {
                    this.u[0].set(a22, pde.f(a3[a22]));
                }
            }

            @Override
            public Vector getRHS(int m2) {
                Vector a22 = a4.getRHS(this.u[m2 - 1], a2[m2 - 1], a2[m2]);
                return a22;
            }
            {
                1 a42;
                super(a32);
            }
        };
        final Vector[] a6 = a5.propagate();
        return new PDESolutionTimeSpaceGrid1D(){

            @Override
            public double u(int m2, int n) {
                ArgumentAssertion.assertRange(m2, 0, M2, "m");
                ArgumentAssertion.assertRange(n, 0, N + 1, "n");
                if (n == 0 || n == N + 1) {
                    throw new UnsupportedOperationException("boundary values are not available");
                }
                return a6[m2].get(n);
            }

            @Override
            public double t(int m2) {
                ArgumentAssertion.assertRange(m2, 0, M2, "m");
                return a2[m2];
            }

            @Override
            public double x(int n) {
                ArgumentAssertion.assertRange(n, 0, N + 1, "n");
                return a3[n];
            }

            @Override
            public int N() {
                return N;
            }

            @Override
            public int M() {
                return M2;
            }
            {
                2 a32;
            }
        };
    }

    public static class Coefficients {
        final double c1;
        final double dt;
        final int N;
        final double c2;
        final double b1;
        final double gamma;
        final HeatEquation1D pde;
        final double dx;
        final double b2;

        public Vector getRHS(Vector um, double tm, double tmp1) {
            DenseVector a2 = new DenseVector(this.N);
            double a3 = 2.0 * (1.0 - this.gamma);
            a2.set(1, (a3 + this.c1 / this.b1 * this.gamma) * um.get(1) + this.gamma * um.get(2) + this.gamma * this.dx / this.b1 * (this.pde.g1(tm) + this.pde.g1(tmp1)));
            for (int a4 = 2; a4 < this.N; ++a4) {
                a2.set(a4, this.gamma * um.get(a4 - 1) + a3 * um.get(a4) + this.gamma * um.get(a4 + 1));
            }
            a2.set(this.N, this.gamma * um.get(this.N - 1) + (a3 + this.c2 / this.b2 * this.gamma) * um.get(this.N) + this.gamma * this.dx / this.b2 * (this.pde.g2(tm) + this.pde.g2(tmp1)));
            return a2;
        }

        public Coefficients(HeatEquation1D pde, int N, double dx, double dt) {
            this.pde = pde;
            this.N = N;
            this.dx = dx;
            this.dt = dt;
            this.c1 = pde.c1();
            this.c2 = pde.c2();
            this.b1 = this.c1 + (1.0 - this.c1) * dx;
            this.b2 = this.c2 + (1.0 - this.c2) * dx;
            this.gamma = pde.beta() * (dt / (dx * dx));
        }

        public TridiagonalMatrix getLHS() {
            double[] a2 = new double[this.N - 1];
            Arrays.fill(a2, -this.gamma);
            double[] a3 = new double[this.N];
            Arrays.fill(a3, 2.0 * (1.0 + this.gamma));
            a3[0] = a3[0] - this.gamma * this.c1 / this.b1;
            int n = this.N - 1;
            a3[n] = a3[n] - this.gamma * this.c2 / this.b2;
            return new TridiagonalMatrix(new double[][]{a2, a3, a2});
        }
    }
}

